import 'dart:io';

import 'package:echo_app/shared/core.session.dart';

import '../global/global.dart';
import 'package:shared_preferences/shared_preferences.dart';
import '../models/constant-storage.dart';
import 'package:http_interceptor/http_interceptor.dart';

class Auth implements InterceptorContract {
  String? _token = '';
  // ignore: non_constant_identifier_names
  Future<void> MyAuth() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    _token = prefs.getString(ConstantStorage.tokenName)!;
    if (_token != null) {
      Global.token = '';
      Global.token = "Bearer " + _token!;
    } else {
      Global.token = '';
    }

    Global.httpOptions = {
      HttpHeaders.authorizationHeader: Global.token,
      HttpHeaders.contentTypeHeader: 'application/json',
      "LanguageId": CoreSession.selectedLanguageId.toString(),
    };
  }

  @override
  Future<RequestData> interceptRequest({required RequestData data}) {
    throw UnimplementedError();
  }

  @override
  Future<ResponseData> interceptResponse({required ResponseData data}) {
    throw UnimplementedError();
  }
}
