class OperatorModel {
  int outletId = -1;
  int customerId = -1;
  String name = '';
  String code = '';
  bool active = false;
  bool taxable = false;
  String divisionIds = '';
  int routeEmployeeId = -1;
  int routeOperatorId = -1;
  int routeVehicleId = -1;
  int routeOrganizationId = -1;
  String routeLoadingWarehouseIds = '';
  String appVersion = '';
  int numberOfDigit = 0;
  String? username = '';
  String password = '';
  String currencyCode = '';
  bool isCurrentUser = false;
  bool isMultiUser = false;
  List<OperatorCustomerModel> operatorCustomers = [];
  List<ItemOffers> itemOffers = [];
  OperatorModel();
  Map toJson() {
    return {
      'outletId': customerId,
      'customerId': customerId,
      'name': name,
      'code': code,
      'active': active,
      'taxable': taxable,
      'divisionIds': divisionIds,
      'routeEmployeeId': routeEmployeeId,
      'routeOperatorId': routeOperatorId,
      'routeVehicleId': routeVehicleId,
      'routeOrganizationId': routeOrganizationId,
      'routeLoadingWarehouseIds': routeLoadingWarehouseIds,
      'appVersion': appVersion,
      'numberOfDigit': numberOfDigit,
      'username': username,
      'password': username,
      'currencyCode': currencyCode,
      'isCurrentUser': isCurrentUser,
      'isMultiUser': isMultiUser,
      'operatorCustomers': List<OperatorCustomerModel>.from(
          operatorCustomers.map((model) => model.toJson())),
      'itemOffers':
          List<ItemOffers>.from(itemOffers.map((model) => model.toJson()))
    };
  }
 

  OperatorModel.fromJson(Map<String, dynamic> json)
      : outletId = json['outletId'],
        customerId = json['customerId'],
        name = json['name'],
        code = json['code'],
        active = json['active'],
        taxable = json['taxable'],
        divisionIds = json['divisionIds'],
        routeEmployeeId = json['routeEmployeeId'],
        routeOperatorId = json['routeOperatorId'],
        routeVehicleId = json['routeVehicleId'],
        routeOrganizationId = json['routeOrganizationId'],
        routeLoadingWarehouseIds = json['routeLoadingWarehouseIds'],
        appVersion = json['appVersion'] == null ? '' : json['appVersion'],
        numberOfDigit = json['numberOfDigit'],
        username = json['username'] == null ? '' : json['username'],
        password = json['username'] == null ? '' : json['username'],
        currencyCode = json['currencyCode'] == null ? '' : json['currencyCode'],
        isCurrentUser =
            json['isCurrentUser'] == null ? false : json['isCurrentUser'],
        isMultiUser = json['isMultiUser'] == null ? false : json['isMultiUser'],
        operatorCustomers = List<OperatorCustomerModel>.from(
            json['operatorCustomers']
                .map((model) => OperatorCustomerModel.fromJson(model))),
        itemOffers = List<ItemOffers>.from(
            json['itemOffers'].map((model) => ItemOffers.fromJson(model)));
}

class OperatorForLogin {
  String username = '';
  String password = '';
  String appVersion = '';

  Map toJson() =>
      {'username': username, 'password': password, 'appVersion': appVersion};
}

class OperatorCustomerModel {
  int customerId = -1;
  int outletId = -1;
  int routeEmployeeId = -1;
  int mainDivisionId = -1;
  String customerName = '';
  String employeeName = '';
  String supervisorName = '';
  String phone = '';
  String employeePhone = '';
  String supervisorPhone = '';
  String channelName = '';
  String className = '';
  double longitude = -1;
  double latitude = -1;
  String location = '';
  String address = '';
  int balance = -1;
  int creditLimit = -1;
  OperatorCustomerModel();
  Map toJson() => {
        'customerId': customerId,
        'outletId': outletId,
        'routeEmployeeId': routeEmployeeId,
        'mainDivisionId': mainDivisionId,
        'customerName': customerName,
        'employeeName': employeeName,
        'supervisorName': supervisorName,
        'phone': phone,
        'employeePhone': employeePhone,
        'supervisorPhone': supervisorPhone,
        'channelName': channelName,
        'className': className,
        'longitude': longitude,
        'latitude': latitude,
        'location': location,
        'address': address,
        'balance': balance,
        'creditLimit': creditLimit
      };

  OperatorCustomerModel.fromJson(Map<String, dynamic> json)
      : customerId = json['customerId'],
        outletId = json['outletId'],
        routeEmployeeId = json['routeEmployeeId'],
        mainDivisionId = json['mainDivisionId'],
        customerName = json['customerName'] == null ? '' : json['customerName'],
        employeeName = json['employeeName'] == null ? '' : json['employeeName'],
        supervisorName =
            json['supervisorName'] == null ? '' : json['supervisorName'],
        phone = json['phone'] == null ? '' : json['phone'],
        employeePhone =
            json['employeePhone'] == null ? '' : json['employeePhone'],
        supervisorPhone =
            json['supervisorPhone'] == null ? '' : json['supervisorPhone'],
        channelName = json['channelName'] == null ? '' : json['channelName'],
        className = json['className'] == null ? '' : json['className'],
        longitude = json['longitude'],
        latitude = json['latitude'],
        location = json['location'] == null ? '' : json['location'],
        address = json['address'] == null ? '' : json['address'],
        balance = json['balance'],
        creditLimit = json['creditLimit'];
}

class ItemOffers {
  int itemId = -1;
  String offerIds = '';
  Map toJson() => {'itemId': itemId, 'offerIds': offerIds};
  ItemOffers.fromJson(Map<String, dynamic> json)
      : itemId = json['itemId'],
        offerIds = json['offerIds'] != null ? '' : json['offerIds'];
}
