import 'package:timeago/timeago.dart';
import 'package:get/get.dart';

/// English Messages
class Messages implements LookupMessages {
  @override
  String prefixAgo() => '';
  @override
  String prefixFromNow() => '';
  @override
  String suffixAgo() => 'ago'.tr;
  @override
  String suffixFromNow() => 'from-now'.tr;
  @override
  String lessThanOneMinute(int seconds) => 'a-moment'.tr;
  @override
  String aboutAMinute(int minutes) => 'a-minute'.tr;
  @override
  String minutes(int minutes) => '$minutes' + 'minutes'.tr;
  @override
  String aboutAnHour(int minutes) => 'about-an-hour'.tr;
  @override
  String hours(int hours) => '$hours ' + 'hours'.tr;
  @override
  String aDay(int hours) => 'a-day'.tr;
  @override
  String days(int days) => '$days ' + 'days'.tr;
  @override
  String aboutAMonth(int days) => 'about-a-month'.tr;
  @override
  String months(int months) => '$months ' + 'months'.tr;
  @override
  String aboutAYear(int year) => 'about-a-year'.tr;
  @override
  String years(int years) => '$years ' + 'years'.tr;
  @override
  String wordSeparator() => ' ';
}
