import 'package:echo_app/screens/items_list_page/item_list.page.dart';
import 'package:echo_app/widgets/classification_card.widget.dart';
import 'package:flutter/material.dart';

import '../../shared/core.session.dart';
import '../search_Screen/search_screen.dart';

// ignore: must_be_immutable
class AllCalssificationPage extends StatelessWidget {
  var data;
  var dataList;
  String title = '';

  AllCalssificationPage(this.data, this.title) {
    this.dataList = this.data['dataList'];
  }

  @override
  Widget build(BuildContext context) {
    var size = MediaQuery.of(context).size;

    return Scaffold(
      body: Padding(
        padding: const EdgeInsets.all(10),
        child: GridView.builder(
          // padding: const EdgeInsets.all(10.0),
          itemCount: this.dataList.length,
          gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
            crossAxisCount: size.width >= 768 ? 3 : 2,
            crossAxisSpacing: 10,
            mainAxisSpacing: 10,
          ),
          itemBuilder: (ctx, index) => ClassificationCardWidget(
              this.dataList[index]['id'],
              this.data['sectionTypeId'],
              this.dataList[index]['name'],
              false, (itemIndex) {
                this.dataList[index]['selected']= true;
                CoreSession.currentRange = RangeValues(0,5000);
            Navigator.push(
              context,
              MaterialPageRoute(
                builder: (context) => SearchPage(this.data),
              ),
            );
          }, index),
        ),
      ),
    );
  }
}
