import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/models/constant-storage.dart';
import 'package:echo_app/models/operator.dart';
import 'package:echo_app/screens/tap_page/tap.page.dart';
import 'package:echo_app/services/general.service.dart';
import 'package:echo_app/widgets/general_text_form_field.widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:get/get.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/services.dart';
// ignore: must_be_immutable
class ChangePasswordPage extends StatefulWidget {
  //Style
  @override
  _ChangePasswordPageState createState() => _ChangePasswordPageState();
}

class _ChangePasswordPageState extends State<ChangePasswordPage> {
  var textFieldLableStyle = TextStyle(color: Colors.green);

  var textFieldBorder = UnderlineInputBorder(
    borderSide: BorderSide(color: Colors.green),
  );

  var constPadding = EdgeInsets.fromLTRB(30, 0, 30, 10);

  TextEditingController passController = TextEditingController();

  TextEditingController newPassController = TextEditingController();

  TextEditingController retypePassController = TextEditingController();

  GeneralService _generalService = new GeneralService();

  final _newPassFocusNode = FocusNode();

  final _retryPassFocusNode = FocusNode();

  String password = '';

  String newPassword = '';

  String confirmPassword = '';

  bool invalidPassword = false;

  bool missMatchPassword = false;

  String msg = '';

  bool loading = false;

  onChangePassword() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    this.password = passController.text;
    this.newPassword = newPassController.text;
    this.confirmPassword = retypePassController.text;
    setState(() {
      if (this.password == '' ||
          this.newPassword == '' ||
          this.confirmPassword == '') {
        this.msg = 'fill-data';
        this.invalidPassword = true;
        loading = false;
      } else if (this.password == '' ||
          this.password != prefs.getString(ConstantStorage.password)) {
        this.invalidPassword = true;
        this.msg = 'invalid-password';
        loading = false;
      } else if (this.newPassword == '' ||
          this.newPassword != this.confirmPassword) {
        this.missMatchPassword = true;
        this.msg = 'Password-mismatch';
        loading = false;
      } else {
        this.msg = '';
        this.invalidPassword = false;
        this.missMatchPassword = false;
        loading = false;
      }
    });

    if (!this.invalidPassword && !this.missMatchPassword) {
      var operator = new OperatorModel();
      operator.password = this.newPassword;
      operator.username = prefs.getString(ConstantStorage.username) != null
          ? prefs.getString(ConstantStorage.username)
          : '';
      EasyLoading.show(status: 'loading'.tr);
      var response = await this._generalService.changePassword(operator);
      EasyLoading.dismiss();
      if (response['status'] == GlobalErrors.Success.index) {
        prefs.setString(ConstantStorage.password, operator.password);
        EasyLoading.showSuccess('saved-successfully'.tr);
        loading = false;
        Navigator.pushReplacement(
          context,
          MaterialPageRoute(
            builder: (context) => TapPage(),
          ),
        );
      } else {
        loading = false;
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor: Variables.color_status_bar_primary,
      ),
    );
    _onSubmitPass() {
      FocusScope.of(context).requestFocus(_newPassFocusNode);
    }

    _onSubmitNewPass() {
      FocusScope.of(context).requestFocus(_retryPassFocusNode);
    }

    _onSubmitRetypePass() {
      this.onChangePassword();
    }

    return SafeArea(
      child: Scaffold(
        appBar: AppBar(
            backgroundColor: Variables.color_primary,
            title: Text("change-password".tr),
            automaticallyImplyLeading: false,
            actions: <Widget>[
              IconButton(
                  icon: Icon(Icons.close),
                  onPressed: () {
                    Navigator.pop(context);
                  }),
            ]),
        body: Center(
          child: Form(
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              children: <Widget>[
                Padding(
                  padding: const EdgeInsets.symmetric(vertical: 10),
                  child: Text(
                    this.msg.tr,
                    textAlign: TextAlign.center,
                    style: TextStyle(
                      color: Colors.redAccent,
                    ),
                  ),
                ),
                GeneralTextFormFieldWidget(
                    "password".tr,
                    passController,
                    false,
                    '',
                    true,
                    true,
                    null,
                    _onSubmitPass,
                    null,
                    constPadding,
                    null,
                    1,
                    true,
                    false,
                    false,
                    15,
                    TextInputType.text),
                GeneralTextFormFieldWidget(
                    "new-password".tr,
                    newPassController,
                    false,
                    '',
                    true,
                    true,
                    null,
                    _onSubmitNewPass,
                    null,
                    constPadding,
                    _newPassFocusNode,
                    1,
                    true,
                    false,
                    false,
                    15,
                    TextInputType.text),
                GeneralTextFormFieldWidget(
                    "Re-type-password".tr,
                    retypePassController,
                    false,
                    '',
                    true,
                    true,
                    null,
                    _onSubmitRetypePass,
                    null,
                    constPadding,
                    _retryPassFocusNode,
                    1,
                    true,
                    false,
                    false,
                    15,
                    TextInputType.text),
              ],
            ),
          ),
        ),
        floatingActionButtonLocation: FloatingActionButtonLocation.endFloat,
        floatingActionButton: FloatingActionButton(
          backgroundColor: Variables.color_primary,
          child: Icon(Icons.check),
          onPressed: () {
            if (!loading) {
              loading = true;
              this.onChangePassword();
            }
          },
        ),
      ),
    );
  }
}
