import 'package:echo_app/global/global.dart';
import 'package:echo_app/screens/my_order/my_order.page.dart';
import 'package:echo_app/screens/notifications/notification.page.dart';
import 'package:echo_app/shared/core.session.dart';
import '../../theme/variables.dart';
import './widget/contact_us_from.dart';
import './widget/head_office.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:material_segmented_control/material_segmented_control.dart';

class ContactUsPage extends StatefulWidget {
  @override
  _ContactUsPageState createState() => _ContactUsPageState();
}

class _ContactUsPageState extends State<ContactUsPage> {
  Map<int, Widget> _titles = {};
  Map<int, Widget> _children = {};
  int _currentSelection = 0;
  int customerId = -1;

  initState() {
    customerId = CoreSession.currentOperator['customerId'];
    if (customerId != Global.GuestCustomerId) {
      this.fillSegment();
    }

    super.initState();
  }

  fillSegment() {
    this._titles = {
      0: Text("head-office".tr),
      1: Text("contact-us".tr),
    };
    this._children = {
      0: HeadOffice(),
      1: ContactUsForm(),
    };
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
        appBar: AppBar(
          automaticallyImplyLeading: false,
          backgroundColor: Colors.white,
          title: Row(
            children: [
              IconButton(onPressed: (){
                Navigator.pop(context);
              }, icon: Icon(Icons.arrow_back,color: Colors.black,)),
              Text('contact-us'.tr,style: TextStyle(color: Colors.black),),
              Spacer(),
              CoreSession.newNotificationCount > 0 ?
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30))
                  :     IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => MyOrderPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/default/cart.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
            ],
          ),
        ),
        body: customerId != Global.GuestCustomerId
            ? Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Expanded(
                    flex: 1,
                    child: Container(
                      width: 1000,
                      child: MaterialSegmentedControl(
                        children: _titles,
                        selectionIndex: _currentSelection,
                        borderColor: Variables.color_primary,
                        selectedColor: Variables.color_primary,
                        unselectedColor: Colors.white,
                        borderRadius: 10,
                        verticalOffset: 0,
                        disabledChildren: [
                          2,
                        ],
                        onSegmentChosen : (int index) {
                          setState(() {
                            _currentSelection = index;
                          });
                        },
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 9,
                    child: Container(
                      child: _children[_currentSelection],
                    ),
                  ),
                ],
              )
            : HeadOffice(),
      ),
    );
  }
}
