import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/screens/tap_page/tap.page.dart';
import 'package:echo_app/services/general.service.dart';
import 'package:echo_app/widgets/general_text_form_field.widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:get/get.dart';

import '../../../theme/variables.dart';

class ContactUsForm extends StatefulWidget {
  @override
  _ContactUsFormState createState() => _ContactUsFormState();
}

class _ContactUsFormState extends State<ContactUsForm> {
  TextEditingController subjectControoler = new TextEditingController();
  TextEditingController messageControoler = new TextEditingController();
  GeneralService _generalService = new GeneralService();
  final _messageFocusNode = FocusNode();
  final _form = GlobalKey<FormState>();
  String subject = '';
  String message = '';
  bool subjectErr = false;
  bool messageErr = false;
  bool loading = false;

  Future<void> _saveForm() async {
    subject = subjectControoler.text;
    message = messageControoler.text;
    if (subject.isEmpty) {
      setState(() {
        subjectErr = true;
        loading = false;
        return;
      });
    }
    if (message.isEmpty) {
      setState(() {
        messageErr = true;
        loading = false;
        return;
      });
    }
    if (subject.isNotEmpty && message.isNotEmpty) {
      EasyLoading.show();
      var response = await _generalService.submitContactUS(subject, message);
      if (response['status'] == GlobalErrors.Success.index) {
        loading = false;
        EasyLoading.showSuccess('saved-successfully'.tr);
        Navigator.pushReplacement(
          context,
          MaterialPageRoute(
            builder: (context) => TapPage(),
          ),
        );
      } else {
        //Error
        loading = false;
        EasyLoading.showError('error'.tr);
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    _onSubmitSubject() {
      FocusScope.of(context).requestFocus(_messageFocusNode);
    }

    _onSubmitMsg() {
      if (!loading) {
        loading = true;
        _saveForm();
      }
    }

    return Scaffold(
      body: Form(
        key: _form,
        child: Container(
          padding: EdgeInsets.symmetric(horizontal: 30),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              GeneralTextFormFieldWidget(
                  "subject",
                  subjectControoler,
                  false,
                  '',
                  true,
                  false,
                  null,
                  _onSubmitSubject,
                  null,
                  EdgeInsets.fromLTRB(0, 5, 0, 5),
                  null,
                  1,
                  true,
                  subjectErr,
                  false,
                  15,
                  TextInputType.text),

              GeneralTextFormFieldWidget(
                  "message",
                  messageControoler,
                  false,
                  '',
                  true,
                  false,
                  null,
                  _onSubmitMsg,
                  null,
                  EdgeInsets.fromLTRB(0, 5, 0, 5),
                  _messageFocusNode,
                  8,
                  true,
                  messageErr,
                  false,
                  15,
                  TextInputType.text),

              // TextFieldWidget(true, EdgeInsets.fromLTRB(30, 30, 30, 10),
              //     subjectControoler, "subject"),
              // TextAreaWidget(EdgeInsets.fromLTRB(30, 30, 30, 10),
              //     messageControoler, "message"),
            ],
          ),
        ),
      ),
      floatingActionButtonLocation: FloatingActionButtonLocation.endFloat,
      floatingActionButton: FloatingActionButton(
        backgroundColor: Variables.color_primary,
        child: Icon(Icons.check),
        onPressed: () {
          _saveForm();
        },
      ),
    );
  }
}
