import 'dart:io';

import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/enums/social_media.dart';
import 'package:echo_app/services/general.service.dart';
import 'package:echo_app/widgets/no_data.widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:get/get.dart';

import '../../../theme/variables.dart';
//import 'package:map_launcher/map_launcher.dart';

class HeadOffice extends StatefulWidget {
  @override
  _HeadOfficeState createState() => _HeadOfficeState();
}

class _HeadOfficeState extends State<HeadOffice> {
  var headOfficeDetails;

  String mobileNo = '';
  GeneralService _generalService = new GeneralService();
  initState() {
    super.initState();
    _getCompanyDetails();
  }

  openSocial(String url, SocialMediaType type) async {
    var mode = LaunchMode.externalApplication;
    if (type == SocialMediaType.Mobile) {
      final Uri _url = Uri(scheme: 'tel', path: url);
      launchUrl(_url);
    }
    if (type == SocialMediaType.Fax) {}
    if (type == SocialMediaType.Email) {
      final Uri _url = Uri(scheme: 'mailto', path: url);
      launchUrl(_url);
    }
    if (type == SocialMediaType.Location) {
      var _coords = url.split(',');
      var _urlAndroid = _coords[0] + "," + _coords[1];
      final _url = Uri.parse(
          'https://www.google.com/maps/search/?api=1&query=' + _urlAndroid);
      launchUrl(_url, mode: mode);
    }
    if (type == SocialMediaType.Facebook) {
      final _url = Uri.parse(url);
      launchUrl(_url, mode: mode);
    }
    if (type == SocialMediaType.Whatsapp) {
      var _link = '';
      if (Platform.isAndroid) {
        _link = 'https://wa.me/' + url;
      } else {
        _link = 'https://api.whatsapp.com/send?phone=' + url;
      }
      final _url = Uri.parse(_link);
      launchUrl(_url, mode: mode);
    }
    if (type == SocialMediaType.Instagram) {
      final _url = Uri.parse(url);
      launchUrl(_url, mode: mode);
    }
    if (type == SocialMediaType.Youtube) {
      final _url = Uri.parse(url);
      launchUrl(_url, mode: mode);
    }
    if (type == SocialMediaType.Twitter) {
      final _url = Uri.parse(url);
      launchUrl(_url, mode: mode);
    }
    if (type == SocialMediaType.Linkedin) {
      final _url = Uri.parse(url);
      launchUrl(_url, mode: mode);
    }
  }

  Future<dynamic> _getCompanyDetails() async {
    EasyLoading.show(status: 'loading'.tr);
    var response = await _generalService.getCompanyDetails();
    EasyLoading.dismiss();
    if (response['status'] == GlobalErrors.Success.index) {
      setState(() {
        this.headOfficeDetails = response['data'];
      });
    } else {
      EasyLoading.showError('error'.tr);
    }
  }

  @override
  Widget build(BuildContext context) {
    return this.headOfficeDetails != null
        ? Column(
            children: <Widget>[
              if (this.headOfficeDetails['mobileNo'] != '')
                GestureDetector(
                  child: ListTile(
                    leading: Icon(
                      CommunityMaterialIcons.phone,
                      color: Variables.color_primary,
                    ),
                    title: Text(
                      this.headOfficeDetails['mobileNo'],
                    ),
                  ),
                  onTap: () {
                    this.openSocial(this.headOfficeDetails['mobileNo'],
                        SocialMediaType.Mobile);
                  },
                ),
              if (this.headOfficeDetails['fax'] != '')
                GestureDetector(
                  child: ListTile(
                    leading: Icon(
                      CommunityMaterialIcons.fax,
                      color: Variables.color_primary,
                    ),
                    title: Text(
                      this.headOfficeDetails['fax'],
                    ),
                  ),
                  onTap: () {},
                ),
              if (this.headOfficeDetails['email'] != '')
                GestureDetector(
                  child: ListTile(
                    leading: Icon(
                      CommunityMaterialIcons.email_outline,
                      color: Variables.color_primary,
                    ),
                    title: Text(
                      this.headOfficeDetails['email'],
                    ),
                  ),
                  onTap: () {
                    this.openSocial(
                        this.headOfficeDetails['email'], SocialMediaType.Email);
                  },
                ),
              if (this.headOfficeDetails['locationString'] != '' &&
                  this.headOfficeDetails['latitude'] > 0 &&
                  this.headOfficeDetails['longitude'] > 0)
                GestureDetector(
                  child: ListTile(
                    leading: Icon(
                      CommunityMaterialIcons.crosshairs_gps,
                      color: Variables.color_primary,
                    ),
                    title: Text(
                      this.headOfficeDetails['locationString'],
                    ),
                  ),
                  onTap: () {
                    this.openSocial(
                        "${this.headOfficeDetails['latitude'].toString()},${this.headOfficeDetails['longitude'].toString()}",
                        SocialMediaType.Location);
                  },
                ),
              Container(
                padding: EdgeInsets.only(top: 10, right: 15, left: 15),
                child: Center(
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      if (this.headOfficeDetails['facebook'] != '')
                        IconButton(
                          icon: Icon(
                            CommunityMaterialIcons.facebook,
                            color: Variables.color_primary,
                          ),
                          onPressed: () {
                            this.openSocial(this.headOfficeDetails['facebook'],
                                SocialMediaType.Facebook);
                          },
                        ),
                      if (this.headOfficeDetails['whatsapp'] != '')
                        IconButton(
                          icon: Icon(
                            CommunityMaterialIcons.whatsapp,
                            color: Variables.color_primary,
                          ),
                          onPressed: () {
                            this.openSocial(this.headOfficeDetails['whatsapp'],
                                SocialMediaType.Whatsapp);
                          },
                        ),
                      if (this.headOfficeDetails['instagram'] != '')
                        IconButton(
                          icon: Icon(
                            CommunityMaterialIcons.instagram,
                            color: Variables.color_primary,
                          ),
                          onPressed: () {
                            this.openSocial(this.headOfficeDetails['instagram'],
                                SocialMediaType.Instagram);
                          },
                        ),
                      if (this.headOfficeDetails['youtube'] != '')
                        IconButton(
                          icon: Icon(
                            CommunityMaterialIcons.youtube,
                            color: Variables.color_primary,
                          ),
                          onPressed: () {
                            this.openSocial(this.headOfficeDetails['youtube'],
                                SocialMediaType.Youtube);
                          },
                        ),
                      if (this.headOfficeDetails['twitter'] != '')
                        IconButton(
                          icon: Icon(
                            CommunityMaterialIcons.twitter,
                            color: Variables.color_primary,
                          ),
                          onPressed: () {
                            this.openSocial(this.headOfficeDetails['twitter'],
                                SocialMediaType.Twitter);
                          },
                        ),
                      if (this.headOfficeDetails['linkedin'] != '')
                        IconButton(
                          icon: Icon(
                            CommunityMaterialIcons.linkedin,
                            color: Variables.color_primary,
                          ),
                          onPressed: () {
                            this.openSocial(this.headOfficeDetails['linkedin'],
                                SocialMediaType.Linkedin);
                          },
                        ),
                    ],
                  ),
                ),
              ),
            ],
          )
        : NoDataWidget();
  }
}
