import 'package:echo_app/screens/my_order/my_order.page.dart';
import 'package:echo_app/screens/notifications/notification.page.dart';
import 'package:echo_app/services/general.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/widgets/no_data.widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:get/get.dart';

import '../../../enums/global-errors.dart';
import '../../../theme/variables.dart';
import '../../../widgets/no_items_cart.widget.dart';

class FAQsListWidget extends StatefulWidget {
  @override
  State<FAQsListWidget> createState() => _FAQsListWidgetState();
}

class _FAQsListWidgetState extends State<FAQsListWidget> {
  GeneralService _generalService = new GeneralService();
  var faqsList = [];
  @override
  initState() {
    populateFAQsList();
  }

  populateFAQsList() async {
    EasyLoading.show(status: 'loading'.tr);
    var response = await _generalService.getCustomerAppFAQs();
    EasyLoading.dismiss();
    if (response['status'] == GlobalErrors.Success.index) {
      setState(() {
        faqsList = response['data'];
      });
    } else {
      EasyLoading.showError('error'.tr);
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          automaticallyImplyLeading: false,
          backgroundColor: Colors.white,
          title: Row(
            children: [
              IconButton(onPressed: (){
                Navigator.pop(context);
              }, icon: Icon(Icons.arrow_back,color: Colors.black,)),
              Text('FAQs'.tr,style: TextStyle(color: Colors.black),),
              Spacer(),
              CoreSession.newNotificationCount > 0 ?
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30))
                  :     IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => MyOrderPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/default/cart.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
            ],
          ),
        ),
        body: ListView.builder(
          itemCount: faqsList.length == 0 ? 1 : faqsList.length,
          itemBuilder: (BuildContext context, int index) {
            if (faqsList.length == 0) {
              return Center(
                heightFactor: 30,
                child: Text('no-data-found'.tr, style: TextStyle(color: Colors.grey,fontSize: 18)),
              );
            } else {
              return ExpansionTile(
                title: Text(
                  faqsList[index]['question']!,
                  style: TextStyle(
                    fontWeight: FontWeight.bold,
                  ),
                ),
                children: <Widget>[
                  Padding(
                    padding: EdgeInsets.all(16.0),
                    child: Text(
                      faqsList[index]['answer']!,
                    ),
                  ),
                ],
              );
            }
          },
        ));
  }
}
