import 'package:cached_network_image/cached_network_image.dart';
import 'package:carousel_slider/carousel_slider.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:flutter_image_slideshow/flutter_image_slideshow.dart';

// ignore: must_be_immutable
class CarouselSliderWidget extends StatefulWidget {
  List bannerImageList = [];
  CarouselSliderWidget(this.bannerImageList);

  @override
  _CarouselSliderWidgetState createState() => _CarouselSliderWidgetState();
}

class _CarouselSliderWidgetState extends State<CarouselSliderWidget> {
  int _current = 0;

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        Expanded(
          flex: 2,
          child: ImageSlideshow(

            /// Width of the [ImageSlideshow].
            width: double.infinity,

            /// Height of the [ImageSlideshow].
            height: 150,

            /// The page to show when first creating the [ImageSlideshow].
            initialPage: 0,

            /// The color to paint the indicator.
            indicatorColor: Variables.color_primary,
            /// The color to paint behind th indicator.
            indicatorBackgroundColor: Colors.grey,

            /// The widgets to display in the [ImageSlideshow].
            /// Add the sample image file into the images folder
            children: this.widget
                  .bannerImageList
                  .map((item) => Container(
                width: size.width,
                //decoration: BoxDecoration(color: Colors.amber),
                child: CachedNetworkImage(
                  imageUrl: item,
                  fit: BoxFit.fill,
                  placeholder: (context, url) => Center(child: new CircularProgressIndicator()),
                  errorWidget: (context, url, error) => new Icon(Icons.error),
                ),
              )).toList(),

            /// Called whenever the page in the center of the viewport changes.
            onPageChanged: (value) {

            },

            /// Auto scroll interval.
            /// Do not auto scroll with null or 0.
            autoPlayInterval: 5000,

            /// Loops back to first slide.
            isLoop: true,
          ),
        ),
      ],
    );
  }
}

//final List<Widget> imageSliders = 
