import 'package:echo_app/enums/echo-custome-home-page-types.dart';
import 'package:echo_app/screens/all_classification_page/all_classification_page.dart';
import 'package:echo_app/screens/items_list_page/item_list.page.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:echo_app/widgets/classification_card.widget.dart';
import 'package:echo_app/widgets/item_widget.dart';
import 'package:flutter/material.dart';
import 'package:echo_app/services/items.service.dart';
import 'package:get/get.dart';

import '../../item-informations-page/item-informations.page.dart';
import '../../tap_page/tap.page.dart';

// ignore: must_be_immutable
class HorizontalCardList extends StatefulWidget {
  final data;
  String pathStr = '';
  String title = '';
  var dataList = [];
  var newItemList = [];
  HorizontalCardList(this.data) {
    this.dataList = this.data['dataList'];
    this.title = this.data['sectionName'];

      for (var fillter in data['dataList']) {
        switch (fillter['sectionTypeId']) {
          case 1:
              newItemList.addAll(ItemService.items
                  .where((item) =>
              item['brandId'] != null &&
                  item['brandId'] == fillter['id'])
                  .toList());
            break;
          case 2:
              var valid = ItemService.items
                  .where((item) =>
              item['itemCategoryId'] != null &&
                  item['itemCategoryId'] == fillter['id'])
                  .toList();
              newItemList.addAll(valid);

            break;
          case 3:
              var ids = fillter['itemsIds'];

              for (var id in ids) {
                var index = ItemService.items
                    .indexWhere((item) => item['itemId'] == id);

                var packid = -1;
                if (index > -1)
                  packid = ItemService.items[index]['packId'];
                var haveindex = newItemList
                    .indexWhere((item) => item['packId'] == packid);

                if (index > -1 && haveindex == -1) {
                  newItemList.add(ItemService.items[index]);
                }
            }

            break;
          case 4: // brands
            break;
        }
      }

    if (EchoCustomeHomePageTypes.Brands.index == this.data['sectionTypeId'])
      pathStr = 'brand';

    if (EchoCustomeHomePageTypes.Categories.index == this.data['sectionTypeId'])
      pathStr = 'category';

    if (EchoCustomeHomePageTypes.MasterGroupes.index ==
        this.data['sectionTypeId']) pathStr = 'itemGroup';

    if (EchoCustomeHomePageTypes.Special.index == this.data['sectionTypeId'])
      pathStr = 'special';

    // newItemList= ItemService.items.where((item) => item['isNew'] != null && item['isNew'] == true)
    //     .toList();


  }

  @override
  _HorizontalCardListState createState() => _HorizontalCardListState();
}

class _HorizontalCardListState extends State<HorizontalCardList> {

  refreshPage(){
    Navigator.pushReplacement(
        context,
        MaterialPageRoute(
            builder: (BuildContext context) => super.widget));
  }
  OnClickDetails(pack){
    Navigator.of(context).push(MaterialPageRoute(builder: (context) =>ItemInformationsPage(pack)))
    .then((value) {
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (BuildContext context) => TapPage()));
    });
  }

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Container(
      child: Column(
        children: [
          Container(
            padding: EdgeInsets.all(10),
            width: size.width,
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(
                  this.widget.data['sectionTypeId'] == 3
                      ? widget.data['sectionName']
                      : widget.title != ''
                          ? widget.title
                          : this.widget.title,
                  style: Theme.of(context).textTheme.bodyMedium,
                ),
                GestureDetector(
                  child: Text(
                    'see-all'.tr,
                    style: TextStyle(
                        fontSize: Variables.headline5FontSize,
                        color: Variables.color_primary),
                  ),
                  onTap: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                        builder: (context) => AllCalssificationPage(  this.widget.data, widget.title),
                      ),
                    );
                  },
                ),
              ],
            ),
          ),
          Container(
              width: size.width,
              child: ListView.builder(
                scrollDirection: Axis.horizontal,
                itemBuilder: (ctx, index) {
                  return ItemWidget(
                    this.widget.newItemList[index],
                    () {
                      setState(() {
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) =>
                                ItemListPage(this.widget.dataList, index, ''),
                          ),
                        );
                      });
                    },this.widget.newItemList, OnClickDetails,refreshPage
                  );
                },
                itemCount: this.widget.newItemList.length,
              ))
        ],
      ),
    );
  }

}
