import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/services/general.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../theme/variables.dart';

// ignore: must_be_immutable
class HTMLPage extends StatefulWidget {
  int type = 1;
  HTMLPage(this.type);
  @override
  _HTMLPageState createState() => _HTMLPageState();
}

class _HTMLPageState extends State<HTMLPage> {
  String htmlData = "";
  var textLanguages = [];
  GeneralService _generalService = new GeneralService();

  initState() {
    this.getAppProperties();
    super.initState();
  }

  Future<void> getAppProperties() async {
    await _getAppProperties();
  }

  Future<dynamic> _getAppProperties() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    EasyLoading.show(status: 'loading'.tr);
    var response = await _generalService.getAppProperties();
    EasyLoading.dismiss();
    if (response['status'] == GlobalErrors.Success.index) {
      CoreSession.customerAppProperties = response['data'];
      if (widget.type == 1) {
        this.textLanguages =
            CoreSession.customerAppProperties['aboutUsLanguages'];
      } else {
        this.textLanguages =
            CoreSession.customerAppProperties['privacyPolicyLanguages'];
      }

      var languageId = prefs.getInt('languageId');
      for (var item in this.textLanguages) {
        if (item['languageId'] == languageId) {
          setState(() {
            this.htmlData = item['description'];
          });
        }
      }
    } else {
      EasyLoading.showError('error'.tr);
    }
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
        appBar: AppBar(
           backgroundColor: Variables.color_primary,
            title: widget.type == 1
                ? Text("about-us".tr)
                : Text("privacy-policy".tr),
            automaticallyImplyLeading: false,
            actions: <Widget>[
              IconButton(
                  icon: Icon(Icons.close),
                  onPressed: () {
                    Navigator.pop(context);
                  }),
            ]),
        body: this.htmlData != ""
            ? SingleChildScrollView(
            child: Html(data: htmlData),
              )
            : Container(),
      ),
    );
  }
}
