 import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';

// ignore: must_be_immutable
class NotificationListItem extends StatelessWidget {
  var notification;
  var textStyleHead = TextStyle(fontSize: 16, fontWeight: FontWeight.bold);
  var textStyleBody = TextStyle(fontSize: 16);
  var textStyleToDate = TextStyle(fontSize: 16, color: Colors.grey);
  // Variables _variables = new Variables();

  NotificationListItem(this.notification);

  @override
  Widget build(BuildContext context) {
    String imgPath = 'assets/imgs/text-message.png';
    // IconData icon = Icons.message;

    if (notification['typeId'] == 2) {
      // imgPath = CoreSession.notificationImagePath + notification['imageName'];
      imgPath = 'assets/imgs/photo.png';
      // icon = Icons.image;
    } else if (notification['typeId'] == 3) {
      imgPath = 'assets/imgs/video.png';
      // icon = Icons.video_label;
    } else if (notification['orderId'] != '') {
      imgPath = 'assets/imgs/updated-order.png';
      // icon = Icons.edit;
    }

    return Card(
      color: notification['unRead']
          ? Color.fromRGBO(214, 235, 253, .5)
          : Colors.white,
      child: Container(
        padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: <Widget>[
            Flexible(
              flex: 2,
              child: Column(
                children: [
                  //Icon(icon)

                  ConstrainedBox(
                    // panEnabled
                    constraints: BoxConstraints(
                      minWidth: 20,
                      minHeight: 20,
                      maxWidth: 40,
                      maxHeight: 40,
                    ),
                    child: 
                    // notification['typeId'] == 2
                    //     ? 
                    //     Image.network(imgPath, fit: BoxFit.cover)
                    //     : 
                        Image.asset(imgPath, fit: BoxFit.cover),
                    // child: Image.asset(imgPath, fit: BoxFit.cover),
                  )
                ],
              ),
            ),
            //Padding(padding: EdgeInsets.symmetric(horizontal: 5)),
            Flexible(flex: 1, child: Container()),
            Flexible(
              flex: 11,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    child: Column(
                      children: <Widget>[
                        new Text(
                          notification['subject'],
                          style: Theme.of(context).textTheme.bodyMedium,
                        ),
                      ],
                    ),
                  ),
                  Container(
                    child: Text(
                      notification['body'],
                      style: Theme.of(context).textTheme.bodyMedium,
                    ),
                  ),
                  Container(
                    child: Text(
                      notification['createdDate'],
                      style: Theme.of(context).textTheme.bodySmall,
                    ),
                  ),
                 
                ],
              ),
            )
          ],
        ),
      ),
    );
  }
}
