import 'package:echo_app/screens/my_order/my_order.page.dart';
import 'package:echo_app/screens/notifications/notification.page.dart';
import 'package:echo_app/screens/offers/widget/action_buttons.dart';
import 'package:echo_app/screens/offers/widget/offer_details.dart';
import 'package:echo_app/services/offers.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/widgets/no_data.widget.dart';
import 'package:echo_app/widgets/search_bar.dart' as search;
import 'package:echo_app/widgets/utils.dart';
import '../../theme/variables.dart';
import './widget/offer_divider.dart';
import './widget/offer_image.dart';
import './widget/offer_input_output.dart';
import 'widget/offer_title.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class OffersPage extends StatefulWidget {
  var offersList = [];
  bool showAppBar = false;
  bool fromTapPage = false;
  var appearedList = [];
  OffersPage(this.offersList, this.showAppBar, this.fromTapPage) {
    this.appearedList = this.offersList;
  }

  @override
  State<OffersPage> createState() => new _OffersPageState();
}

class _OffersPageState extends State<OffersPage> {
  TextEditingController _searchCtrl = TextEditingController();
  onEnterSearch() {
    setState(
      () {
        if (_searchCtrl.text == '') {
          this.widget.appearedList = this.widget.offersList;
        } else {
          filterOffers();
        }
      },
    );
  }

  filterOffers() {
    if (_searchCtrl.text != '') {
      var filterList = [];
      filterList = _searchCtrl.text.split(' ');
      if (filterList.length > 0) {
        this.widget.appearedList = this.widget.offersList;
        for (var word in filterList) {
          this.widget.appearedList = this
              .widget
              .appearedList
              .where(
                (item) => item['promotionName']
                    .toString()
                    .toLowerCase()
                    .contains(word.toLowerCase()),
              )
              .toList();
        }
      }
    }
  }

  onOfferCountChange(int promotionOptionId, String qty) {}
  onTakeOffer() {}

  @override
  Widget build(BuildContext context) {
    setState(() {
      if (this.widget.fromTapPage && this._searchCtrl.text == '') {
        this.widget.appearedList = OffersService.offers;
        this.widget.offersList = OffersService.offers;
      }
    });

    readMore(int index) {
      var offer = this.widget.appearedList[index];
      Navigator.push(
        context,
        MaterialPageRoute(
          builder: (context) => OfferDetails(offer),
        ),
      );
    }

    Size size = MediaQuery.of(context).size;
    return Scaffold(
        appBar: this.widget.showAppBar
            ? AppBar(
          backgroundColor: Colors.white,
          title: Row(
            children: [
              IconButton(
                  icon: Icon(Icons.arrow_back,color: Colors.black,),
                  onPressed: () {
                    Navigator.pop(context);
                  }),
              Text("offers".tr,style: TextStyle(color: Colors.black),),
              Spacer(),
              CoreSession.newNotificationCount > 0 ?
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30))
                  :     IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => MyOrderPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/default/cart.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
            ],
          ),
          automaticallyImplyLeading: false,)
            : null,
        body: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            this.widget.appearedList.length > 0
                ? Expanded(
                    child: Container(
                      padding: EdgeInsets.all(8),
                      child: Column(
                        children: [
                          Expanded(
                            child:
                            ListView.builder(
                              itemBuilder: (ctx, index) {
                                return Container(
                                  width: size.width,
                                  child: Container(
                                    child: Card(
                                      // shape: BeveledRectangleBorder(
                                      //   borderRadius: BorderRadius.circular(5),
                                      // ),
                                      elevation: 2,
                                      child: Column(
                                        children: <Widget>[
                                          OfferImage(
                                              this.widget.appearedList[index]),
                                          Column(
                                            children: <Widget>[
                                              OfferTitle(this
                                                      .widget
                                                      .appearedList[index]
                                                  ['promotionName']),
                                              OfferDivider(),
                                              OfferInputOutput(
                                                this.widget.appearedList[index]
                                                    ['promotionId'],
                                                this.widget.appearedList[index]
                                                    ['promotionInputs'],
                                                this.widget.appearedList[index]
                                                    ['promotionOutputs'],
                                                this.widget.appearedList[index]
                                                    ['promotionType'],(
                                                this.widget.appearedList[index]
                                                    ['showTakePromotionOption'] ?? false),
                                              ),
                                              if (this
                                                      .widget
                                                      .appearedList[index]
                                                  ['showReadMoreOption'] ?? false)
                                                ActionButtons(index, readMore),
                                              addVerticalSpace(10)
                                            ],
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                );
                              },
                              itemCount: this.widget.appearedList.length,
                            ),
                          ),
                        ],
                      ),
                    ),
                  )
                : Expanded(child: NoDataWidget()),
            Container(height: 20)
          ],
        ));
  }
}

class SimpleDialogItem extends StatelessWidget {
  const SimpleDialogItem(
      {required this.icon,
      required this.color,
      required this.text,
      required this.onPressed});

  final IconData icon;
  final Color color;
  final String text;
  final VoidCallback onPressed;

  @override
  Widget build(BuildContext context) {
    return SimpleDialogOption(
      onPressed: onPressed,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Icon(icon, size: 36.0, color: color),
          Padding(
            padding: const EdgeInsetsDirectional.only(start: 16.0),
            child: Text(text),
          ),
        ],
      ),
    );
  }
}
