import 'package:echo_app/enums/promotion_type.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../theme/variables.dart';
import 'offer_details_card.dart';
import 'offer_details_card_fixed.dart';

// ignore: must_be_immutable
class OfferDetails extends StatelessWidget {
  var offer;
  int promotionId = -1;
  int promotionType = -1;
  String promotionName = '';
  var promotionInputs = [];
  var promotionOutputs = [];
  var inputOutputResult = [];
  OfferDetails(this.offer) {
    promotionId = this.offer['promotionId'];
    promotionType = this.offer['promotionType'];
    promotionName = this.offer['promotionName'];
    promotionInputs = this.offer['promotionInputs'];
    promotionOutputs = this.offer['promotionOutputs'];
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
         backgroundColor: Variables.color_primary,
        title: Text(promotionName),
        automaticallyImplyLeading: false,
        actions: <Widget>[
          IconButton(
              icon: Icon(Icons.close),
              onPressed: () {
                Navigator.pop(context);
              }),
        ],
      ),
      body: promotionType != PromotionTypes.FixedValues.index
          ? Container(
              height: double.infinity,
              child: OfferDetailsCard(promotionInputs, promotionOutputs),
            )
          : Container(
              height: double.infinity,
              child: OfferDetailsCardFixed(this.offer),
            ),
    );
  }

  toQueryString(obj) {
    var parts = [];
    // tslint:disable-next-line:forin
    for (var property in obj) {
      String? value = property['description'];
      if (value != null && value != '') {
        parts.add(value);
      }
    }
    return parts.join(" & ");
  }

  toQueryStringFixed(obj) {
    var parts = [];
    // ignore: unused_local_variable
    var descs = [];
    String str = '';
    // tslint:disable-next-line:forin
    for (var property in obj) {
      var arr = [];
      var decriptions = property["promotionOptionDetails"];
      for (var i in decriptions) {
        arr.add(i['description']);
      }
      str = arr.join(" & ");
      parts.add(str);
    }
    return parts.join("\n" + "or".tr + "\n");
  }
  // Widget RangeValuesWidget(promotionInputs, promotionOutputs) {
  //   return E(
  //     height: 300,
  //     child: promotionInputs.map(
  //       (value) {
  //         return Text("lll");
  //       },
  //     ).toList(),
  //   );
  // }
}
