// ignore_for_file: must_be_immutable

import 'package:carousel_slider/carousel_slider.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/widgets/view_image.widget.dart';
import 'package:flutter/material.dart';

class OfferImage extends StatefulWidget {
  var promotion;
  var imageList = [];

  OfferImage(this.promotion) {
    this.imageList = this.promotion['imageList'];
  }

  @override
  State<OfferImage> createState() => _OfferImageState();
}

class _OfferImageState extends State<OfferImage> {
  // ignore: unused_field
  int _current = 0;
  final path = CoreSession.api + 'img/Echo/promotions/';
  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return this.widget.imageList.length == 0
        ? Container(
            width: size.width,
            child: ClipRRect(
              borderRadius: BorderRadius.circular(5),
              child: Image.asset(
                "assets/imgs/no-promo-img.jpg",
                fit: BoxFit.fitWidth,
                height: 100,
              ),
            ),
          )
        : CarouselSlider(
            items: this
                .widget
                .imageList
                .map((item) => GestureDetector(
                      onTap: () {
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) => ViewImageWidget(
                                path +
                                    this
                                        .widget
                                        .promotion['promotionId']
                                        .toString() +
                                    '/' +
                                    item,
                                ""),
                          ),
                        );
                      },
                      child: Container(
                        width: size.width,
                        //decoration: BoxDecoration(color: Colors.amber),
                        child: ClipRRect(
                          borderRadius: BorderRadius.only(
                            topRight: Radius.circular(5),
                            topLeft: Radius.circular(5),
                          ),
                          child: Image.network(
                            path +
                                this
                                    .widget
                                    .promotion['promotionId']
                                    .toString() +
                                '/' +
                                item,
                            fit: BoxFit.cover,
                          ),
                        ),
                      ),
                    ))
                .toList(),
            options: CarouselOptions(
              autoPlay: true,
              enlargeCenterPage: true,
              aspectRatio: 2.0,
              viewportFraction: 1,
              autoPlayCurve: Curves.fastOutSlowIn,
              onPageChanged: (index, reason) {
                setState(() {
                  this._current = index;
                });
              },
            ),
          );
  }
}
