import 'package:flutter/material.dart';
import 'package:get/get.dart';


// ignore: must_be_immutable
class OffersDialogContent extends StatelessWidget {
  var promotionInput;
  var promotionOutput;
  OffersDialogContent(this.promotionInput, this.promotionOutput);
  @override
  Widget build(BuildContext context) {
    return Container(
      height: MediaQuery.of(context).size.height / 5,
      child: ListView.builder(
        itemBuilder: (ctx, index) {
          return OffersDialogContentCard(
              this.promotionInput[index], this.promotionOutput[index]);
        },
        itemCount: this.promotionInput.length,
      ),
    );
  }
}

// ignore: non_constant_identifier_names
Widget OffersDialogContentCard(promotionInput, promotionOutput) {
  String inputDesc = promotionInput['promotionOptionDetails'][0]['description'];
  String outputDesc =
      promotionOutput['promotionOptionDetails'][0]['description'];
  return Container(
    margin: EdgeInsets.only(bottom: 5),
    child: Column(
      children: <Widget>[
        Row(
          children: [
            Text(
              'should-buy'.tr + ': ',
              style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
            ),
            Text(
              inputDesc,
              style: TextStyle(fontSize: 16),
            ),
          ],
        ),
        Row(
          children: [
            Text('will-get'.tr + ': ',
                style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16)),
            Text(
              outputDesc,
              style: TextStyle(fontSize: 16),
            ),
          ],
        ),
      ],
    ),
  );
}
