import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/enums/order_ststus.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class OrderHistoryListItem extends StatefulWidget {
  var order;
  Function reOrder;
  Function cancelOrder;
  OrderHistoryListItem(this.order, this.reOrder, this.cancelOrder);

  @override
  _OrderHistoryListItemState createState() => _OrderHistoryListItemState();
}

class _OrderHistoryListItemState extends State<OrderHistoryListItem> {
  var textStyle = TextStyle(fontSize: 16);
  var textStyleToDate = TextStyle(fontSize: 16, color: Colors.grey);

  @override
  Widget build(BuildContext context) {
    Color color = Colors.orange.shade400;
    IconData icon = Icons.done_rounded;
    String statusDescription = widget.order['status'];

// preparing, delivered, on hold, reschdualed, invoiced
    setState(() {
      if (widget.order['isOnTheWay'] == true) {
        color = Colors.blue;
        // icon = Icons.delivery_dining;
        icon = CommunityMaterialIcons.truck_delivery;
        statusDescription = 'on-the-way'.tr;
      } else if (widget.order['isPreparing'] == true) {
        color = Colors.blue;
        // icon = Icons.pending_actions;
        icon = CommunityMaterialIcons.progress_upload;
        statusDescription = 'preparing'.tr;
      } else if (widget.order['statusId'] == OrderStatus.Canceled.index ||
          widget.order['statusId'] == OrderStatus.RejectCompleted.index ||
          widget.order['statusId'] == OrderStatus.Rejected.index ||
          widget.order['statusId'] == OrderStatus.Deleted.index) {
        color = Colors.red;
        icon = CommunityMaterialIcons.close;
      } else if (widget.order['statusId'] == OrderStatus.Delivered.index) {
        color = Colors.green;
        icon = CommunityMaterialIcons.package_variant_closed;
      } else if (widget.order['statusId'] == OrderStatus.Invoiced.index) {
        color = Colors.green;
        icon = CommunityMaterialIcons.package_variant_closed;
      } else if (widget.order['statusId'] == OrderStatus.New.index) {
        color = Colors.orange.shade400;
        icon = CommunityMaterialIcons.star_plus;
      } else if (widget.order['statusId'] == OrderStatus.Rescheduled.index) {
        color = Colors.orange.shade400;
        icon = CommunityMaterialIcons.calendar_refresh;
      } else if (widget.order['statusId'] == OrderStatus.OnHold.index) {
        color = Colors.red;
        icon = Icons.mode_standby;
      } else {
        color = Colors.orange.shade400;
        icon = Icons.done_rounded;
      }
    });

    return Card(
        child: Container(
      decoration: BoxDecoration(
          border: Border(
        left: BorderSide(
          color: color,
          width: 5,
        ),
      )),
      padding: EdgeInsets.symmetric(vertical: 15, horizontal: 15),
      child: Column(
        children: <Widget>[
          Row(
            children: <Widget>[
              Container(
                  child: Text(widget.order['orderId'],
                      style: Theme.of(context).textTheme.bodyMedium))
            ],
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: <Widget>[
              Row(
                children: <Widget>[
                  Text(
                    "orderDate".tr +" : "+widget.order['orderDate'],
                    style: Theme.of(context).textTheme.bodySmall,
                  ),
                ],
              ),
              Row(
                children: <Widget>[
                  IconButton(
                      onPressed: () => {widget.reOrder(widget.order)},
                      icon: Icon(
                        Icons.copy,
                        color: Variables.color_primary,
                      )),
                  widget.order['allowCancel'] && widget.order['statusId'] != OrderStatus.Delivered
                      ? IconButton(
                          onPressed: () async => {
                                await CoreSession.showYesNoDialog(context, () {
                                  widget.cancelOrder(widget.order);
                                }, 'confirm-cancel'.tr)
                              },
                          icon: Icon(
                            Icons.cancel,
                            color: Variables.color_primary,
                          ))
                      : Text(''),
                ],
              )
            ],
          ),
          Row(
            children: <Widget>[
              Text(
                "desiredDeliveryDate".tr +" : "+ (widget.order['desiredDeliveryDate']?? ''),
                style: Theme.of(context).textTheme.bodySmall,
              ),
            ],
          ),
          Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: <Widget>[
                Container(
                  // width: 100,
                  child: Row(
                    children: <Widget>[
                      Icon(
                        icon,
                        color: color,
                      ),
                      Text(statusDescription, style: Theme.of(context).textTheme.bodyMedium,)
                    ],
                  ),
                ),
                Text(
                    widget.order['netTotal']
                        .toStringAsFixed(CoreSession.numberOfDigits),
                    style: Theme.of(context).textTheme.bodyMedium)
              ])
        ],
      ),
    ));
  }
}
