import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/screens/order_history/order_history.page.dart';
import 'package:echo_app/screens/tap_page/tap.page.dart';
import 'package:echo_app/services/general.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../theme/variables.dart';

// ignore: must_be_immutable
class CorrectOrder extends StatefulWidget {
  final String orderId;
  final double earnPoints;

  CorrectOrder(this.orderId, this.earnPoints);
  @override
  _CorrectOrderState createState() => _CorrectOrderState();
}

class _CorrectOrderState extends State<CorrectOrder> {

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return WillPopScope(
      onWillPop: () async {
        return false;
      },
      child: SafeArea(
        child: Scaffold(
          body: Column(
            children: [
              Center(
                child: Image.asset(
                  "assets/imgs/correct.gif",
                  height: size.width,
                  width: size.width,
                ),
              ),
              Center(
                child: Text(
                  // 'Your Order has been \naccepted',
                  'order_accepted'.tr,
                  style: TextStyle(
                      color: Colors.black,
                      fontSize: Variables.headline1FontSize),
                  textAlign: TextAlign.center,
                ),
              ),
              // SizedBox(
              //   height: 20,
              // ),
              // Center(
              //   child: Text(
              //     'Your items has been placed and is on\nit’s way to being processed',
              //     style: TextStyle(
              //         color: Colors.black,
              //         fontSize: Variables.headline2FontSize),
              //     textAlign: TextAlign.center,
              //   ),
              // ),
              SizedBox(
                height: 40,
              ),
              Center(
                child: Container(
                  width: 250,
                  child: Text(
                    'Order-message'.tr,
                    style: TextStyle(
                      fontFamily: 'Poppins',
                        color: Colors.grey,
                        fontWeight: FontWeight.w600,
                        fontSize: 12),
                    textAlign: TextAlign.center,
                  ),
                ),
              ),
              
              SizedBox(
                height: 20,
              ),
              InkWell(child: Text('back_to_home'.tr,style: TextStyle(color: Colors.grey,fontWeight: FontWeight.bold,fontSize: Variables.headline1FontSize),),
                  onTap:(){
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(builder: (context) => TapPage()),
                    );
                  }
              ),
              if(this.widget.earnPoints  > 0)
              Text.rich(
                TextSpan(
                  text: 'You_earned'.tr + ' ${this.widget.earnPoints}' + ' ' + 'Points'.tr,
                  children: [
                    WidgetSpan(
                      child: Padding(
                        padding: EdgeInsets.symmetric(horizontal: 2.0),
                        child: Icon(
                          Icons.star,
                          size: 16.0,
                          color: Colors.amber,
                        ),
                      ),
                    ),
                  ],
                ),
              ),
              Spacer(),
              Padding(
                padding: const EdgeInsets.all(20.0),
                child: ElevatedButton(
                  onPressed: () {
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(builder: (context) => OrderHistoryPage()),
                    );
                  },
                  child: Row(
                    children: [
                      Spacer(),
                      Padding(
                        padding: const EdgeInsets.all(20.0),
                        child: Text(
                          'Track-Order'.tr,
                          style: TextStyle(
                              color: Colors.white,
                              fontSize: Variables.headline1FontSize),
                          textAlign: TextAlign.center,
                        ),
                      ),
                      Spacer(),
                    ],
                  ),
                  style: ElevatedButton.styleFrom(
                    backgroundColor: Variables.color_primary,
                    shape: RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(10),
                    ),
                  ),
                ),
              ),
              Spacer()
            ],
          ),
        ),
      ),
    );
  }
}
