import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class Summery extends StatelessWidget {
  var summary;
  var summeryObj;
  double calculatedDiscountTotalBeforFirstUserDiscount = 0;
  double sumDiscount = 0;
  double grossTotal = 0;
  double netTotal = 0;
  double sumTax = 0;
  String currencyCode = CoreSession.currentOperator['currencyCode'];
  Summery(this.summary) {
    this.summeryObj = this.summary[0];
    this.calculatedDiscountTotalBeforFirstUserDiscount =
        this.summeryObj['calculatedDiscountTotalBeforFirstUserDiscount'];
    this.sumDiscount = this.summeryObj['calculatedTotalDiscount'];
    this.grossTotal = this.summeryObj['grossTotal'];
    this.netTotal = this.summeryObj['netTotal'];
    this.sumTax = this.summeryObj['calculatedTotalTax'];
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Column(children: [
              Text("gross".tr + ": ", style: TextStyle(fontSize: 15))
            ]),
            Column(children: [
              Text(this.grossTotal.toString() + " " + this.currencyCode,
                  style: TextStyle(fontSize: 15))
            ]),
          ],
        ),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Column(children: [
              Text("total_discount".tr + ": ", style: TextStyle(fontSize: 15))
            ]),
            // Column(children: [
            //   Text(":", style: TextStyle(fontSize: 15))
            // ]),
            Column(children: [
              Text(this.sumDiscount.toString() + " " + this.currencyCode,
                  style: TextStyle(fontSize: 15))
            ]),
          ],
        ),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Column(children: [
              Text("taxTotal".tr + ": ", style: TextStyle(fontSize: 15))
            ]),
            // Column(children: [
            //   Text(":", style: TextStyle(fontSize: 15))
            // ]),
            Column(children: [
              Text(this.sumTax.toString() + " " + this.currencyCode,
                  style: TextStyle(fontSize: 15))
            ]),
          ],
        ),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Column(children: [
              Text("net-total".tr + ": ", style: TextStyle(fontSize: 15))
            ]),
            // Column(children: [
            //   Text(":", style: TextStyle(fontSize: 15))
            // ]),
            Column(children: [
              Text(this.netTotal.toString() + " " + this.currencyCode,
                  style: TextStyle(fontSize: 15))
            ]),
          ],
        )
      ],
    );
  }
}
