import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/screens/my_order/my_order.page.dart';
import 'package:echo_app/screens/notifications/notification.page.dart';
import 'package:echo_app/screens/profile_page/profile.edit.page.dart';
import 'package:echo_app/services/general.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/widgets/general_text_form_field.widget.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../theme/variables.dart';

class ProfilePage extends StatefulWidget {
  @override
  _ProfilePageState createState() => _ProfilePageState();
}

class _ProfilePageState extends State<ProfilePage> {
  initState() {
    super.initState();
    this._populateUserList();
  }

  GeneralService _generalService = new GeneralService();

  var userList = [];
  var selectedUser;

  var textFieldBorder = UnderlineInputBorder(
    borderSide: BorderSide(color: Colors.green),
  );
  var constPadding = EdgeInsets.fromLTRB(0, 5, 0, 10);

  TextEditingController nameController = TextEditingController();
  TextEditingController phoneController = TextEditingController();
  TextEditingController addressController = TextEditingController();
  TextEditingController currentLocationController = TextEditingController();
  TextEditingController currentLocationControllerEdit = TextEditingController();
  TextEditingController balanceController = TextEditingController();
  TextEditingController creditLimitController = TextEditingController();
  TextEditingController pointBalanceController = TextEditingController();
  TextEditingController salespersonNameController = TextEditingController();
  TextEditingController salespersonPhoneController = TextEditingController();
  TextEditingController supervisorNameController = TextEditingController();
  TextEditingController supervisorPhoneController = TextEditingController();
  TextEditingController classNameController = TextEditingController();
  TextEditingController channelnameController = TextEditingController();

  _populateUserList() async {
    EasyLoading.show(status: 'loading'.tr);
    var response = await _generalService.getCustomerAppProfileData();
    EasyLoading.dismiss();
    if (response['status'] ==
        GlobalErrors.Success.index) if (response['data'].length > 0) {
      this.userList = response['data'];
      this.selectedUser = this.userList[0];
      this.fillProfileForm();
    } else {
      this.userList = [];
    }
    else {
      this.userList = [];
      EasyLoading.showError('error'.tr);
    }
  }

  fillProfileForm() {
    nameController.text =
        this.selectedUser['customerName'].toString() != 'null' &&
                this.selectedUser['customerName'].toString() != ''
            ? this.selectedUser['customerName'].toString()
            : '---';
    phoneController.text = this.selectedUser['phone'].toString() != 'null' &&
            this.selectedUser['phone'].toString() != ''
        ? this.selectedUser['phone'].toString()
        : '---';
    addressController.text =
        this.selectedUser['address'].toString() != 'null' &&
                this.selectedUser['address'].toString() != ''
            ? this.selectedUser['address'].toString()
            : '---';
    currentLocationController.text =
        this.selectedUser['location'].toString() != 'null' &&
                this.selectedUser['location'].toString() != ''
            ? this.selectedUser['location'].toString()
            : '---';
    balanceController.text =
        this.selectedUser['balance'].toString() != 'null' &&
                this.selectedUser['balance'].toString() != ''
            ? this.selectedUser['balance'].toString()
            : '---';
    creditLimitController.text =
        this.selectedUser['creditLimit'].toString() != 'null' &&
                this.selectedUser['creditLimit'].toString() != ''
            ? this.selectedUser['creditLimit'].toString()
            : '---';   
   pointBalanceController.text =
            CoreSession.currentOperator['pointsBalance'].toString() != 'null' &&
                CoreSession.currentOperator['pointsBalance'].toString() != ''
            ? CoreSession.currentOperator['pointsBalance'].toString()
            : '---';
    salespersonNameController.text =
        this.selectedUser['employeeName'].toString() != 'null' &&
                this.selectedUser['employeeName'].toString() != ''
            ? this.selectedUser['employeeName'].toString()
            : '---';
    salespersonPhoneController.text =
        this.selectedUser['employeePhone'].toString() != 'null' &&
                this.selectedUser['employeePhone'].toString() != ''
            ? this.selectedUser['employeePhone'].toString()
            : '---';
    supervisorNameController.text =
        this.selectedUser['supervisorName'].toString() != 'null' &&
                this.selectedUser['supervisorName'].toString() != ''
            ? this.selectedUser['supervisorName'].toString()
            : '---';
    supervisorPhoneController.text =
        this.selectedUser['supervisorPhone'].toString() != 'null' &&
                this.selectedUser['supervisorPhone'].toString() != ''
            ? this.selectedUser['supervisorPhone'].toString()
            : '---';
    channelnameController.text =
        this.selectedUser['channelName'].toString() != 'null' &&
                this.selectedUser['channelName'].toString() != ''
            ? this.selectedUser['channelName'].toString()
            : '---';
    classNameController.text =
        this.selectedUser['className'].toString() != 'null' &&
                this.selectedUser['className'].toString() != ''
            ? this.selectedUser['className'].toString()
            : '---';
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
        appBar: AppBar(
          title: Row(
            children: [
              IconButton(onPressed: (){
                Navigator.pop(context);
              }, icon: Icon(Icons.arrow_back,color: Colors.black,)),
              Text('profile'.tr,style: TextStyle(color: Colors.black),),
              Spacer(),
              CoreSession.newNotificationCount > 0 ?
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30))
                  :     IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => NotificationPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/more_icons/notification.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
              IconButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => MyOrderPage()),
                    );
                  },
                  icon: Image.asset(
                      'assets/imgs/default/cart.png',
                      color: Variables.color_primary,
                      height: 33,
                      width: 30)),
            ],
          ),
          automaticallyImplyLeading: false,
          backgroundColor: Colors.white,
        ),
        body: SingleChildScrollView(
          child: Form(
            child: Padding(
              padding: const EdgeInsets.symmetric(horizontal: 30, vertical: 10),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.stretch,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  //View
                  Column(
                    children: [
                      ClipRRect(
                        borderRadius: BorderRadius.circular(80.0),
                        child: Image.network(
                          'https://img0cf.b8cdn.com/images/logo/55/2116055_logo_1657097539_n.png',
                          height: 60.0,
                          width: 60.0,
                        ),
                      ),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(CoreSession.currentOperator['name'] == null ? "" : CoreSession.currentOperator['name'],style:  TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          Text(CoreSession.currentOperator['code'],style:
                          TextStyle(color: Colors.grey, fontSize: Variables.headline2FontSize),),
                        ],
                      ),
                    ],
                  ),
                  GeneralTextFormFieldWidget(
                      "name",
                      nameController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "phone",
                      phoneController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "address",
                      addressController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "current-location",
                      currentLocationController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "balance",
                      balanceController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "credit-limit",
                      creditLimitController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "points_balance",
                      pointBalanceController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),
                      
                  GeneralTextFormFieldWidget(
                      "salesperson-name",
                      salespersonNameController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "salesperson-phone",
                      salespersonPhoneController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.phone),

                  GeneralTextFormFieldWidget(
                      "supervisor-name",
                      supervisorNameController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "supervisor-phone",
                      supervisorPhoneController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.phone),

                  GeneralTextFormFieldWidget(
                      "channel-name",
                      channelnameController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),

                  GeneralTextFormFieldWidget(
                      "class-name",
                      classNameController,
                      false,
                      null,
                      false,
                      false,
                      null,
                      null,
                      null,
                      this.constPadding,
                      null,
                      1,
                      true,
                      false,
                      false,
                      15,
                      TextInputType.text),
                ],
              ),
            ),
          ),
        ),
        floatingActionButtonLocation: FloatingActionButtonLocation.endFloat,
        floatingActionButton: Container(
          child: Row(
            mainAxisAlignment: MainAxisAlignment.end,
            children: [
              Container(
                padding: EdgeInsets.symmetric(horizontal: 1),
                child: FloatingActionButton(
                  backgroundColor: Variables.color_primary,
                  child: Icon(Icons.edit_outlined),
                  onPressed: () {
                    setState(() {
                      Navigator.push(
                        context,
                        MaterialPageRoute(
                          builder: (context) => ProfileEditPage(
                              this.addressController.text,
                              this.phoneController.text,
                              this.currentLocationController.text),
                        ),
                      ).then(
                        (value) => this._populateUserList(),
                      );
                    });
                  },
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
