import 'package:echo_app/screens/home_page/widget/carousel_slider.widget.dart';
import 'package:echo_app/screens/home_page/widget/horizontal_card_list.widget.dart';
import 'package:echo_app/screens/items_list_page/item_list.page.dart';
import 'package:echo_app/screens/search_Screen/widget/FilterPage.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/widgets/search_bar.dart' as search;
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:get/get_utils/src/extensions/internacionalization.dart';
import 'package:rflutter_alert/rflutter_alert.dart';
import 'package:flutter/material.dart';

import '../../services/items.service.dart';
import '../../theme/variables.dart';
import '../home_page/widget/grid_card_list.dart';

class SearchPage extends StatefulWidget {
  var itemdata;

  SearchPage(this.itemdata);
  @override
  _SearchPage createState() => _SearchPage();
}


class _SearchPage extends State<SearchPage> {
  List bannerImageList = [];
  var categories = [];
  var brands = [];
  var filterCategories = [];
  var filterbrands = [];
  var filterMasterGroupes = [];
  var masterGroupes = [];
  var itemList= [];
  var homePageData = [];
  bool isLoading = true;
  bool isCat = true;
  bool isBrand = true;
  bool isDiv = true;
  bool isBan = true;
  bool isGroupes = true;
  TextEditingController _searchCtrl = TextEditingController();
  var locationDesc='';
  ScrollController controller = ScrollController();
  
  @override
  void dispose() {
    for( var Type in CoreSession.homePageData){
      for (var subtype in Type['dataList']){
        subtype['selected'] = false;
      }
    }
  }


  @override
  void deactivate() {
    for( var Type in CoreSession.homePageData){
      for (var subtype in Type['dataList']){
        subtype['selected'] = false;
      }
    }
  }

  initState() {
    EasyLoading.dismiss();
    getHomeData();
    super.initState();
  }

  Future<void> getHomeData()   async {
    if (!CoreSession.dataFilled) {
      setState(() {
        this.bannerImageList = CoreSession.bannersList;

        CoreSession.dataFilled = true;
      });
    } else {
      setState(() {
        this.categories = CoreSession.categoryList;
        this.filterCategories = this.categories;
        this.brands = CoreSession.brandList;
        this.filterbrands = this.brands;
        this.bannerImageList = CoreSession.bannersList;
        this.itemList = ItemService.items;


        this.masterGroupes = CoreSession.masterGroupes;
        this.filterMasterGroupes = this.masterGroupes;
      });
    }
    setState(() {
      isLoading = false;
    });
  }

  void showAlert(contxt) {
    if (CoreSession.hasDeffirentPricesFromGestUser)
      Alert(
        context: context,
        type: AlertType.info,
        useRootNavigator: true,
        title: "message".tr,
        desc: "differnt-prices".tr,
        buttons: [
          DialogButton(
            color: Colors.white,
            child: Text(
              "ok".tr,
              style: TextStyle(color: Colors.green, fontSize: 20),
            ),
            onPressed: () => {
              CoreSession.hasDeffirentPricesFromGestUser = false,
              Navigator.of(context, rootNavigator: true).pop(),
            },
            width: 120,
          )
        ],
      ).show();
  }

  void onClickApply(_currentRange){
    CoreSession.currentRange = _currentRange;
    setState(() {

    });
  }

  @override
  Widget build(BuildContext context) {

    if (CoreSession.hasDeffirentPricesFromGestUser) {
      Future.delayed(Duration.zero, () => showAlert(context));
    }

    onEnterSearch() {
      onClickApply(CoreSession.currentRange);
    }

    Size size = MediaQuery.of(context).size;

    return Scaffold(
      appBar:AppBar(
        backgroundColor: Variables.color_primary,
        title: Container(
          color: Variables.color_primary,
          child: Row(
            children: [
              Expanded(
                flex: 4,
                child: Padding(
                  padding: const EdgeInsets.symmetric(vertical: 50.0),
                  child: search.Search_Bar.CustomSearchBar(_searchCtrl, onEnterSearch , true),
                ),
              ),
              Expanded(
                child: IconButton(onPressed: (){
                  showModalBottomSheet(
                      elevation: 10,
                      isScrollControlled: true,
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(10.0),
                      ),
                      context: context,
                      builder: (BuildContext context) {
                        return FractionallySizedBox(
                            heightFactor: 0.8,
                            child: Container(child:FilterPage(this.onClickApply,CoreSession.currentRange)));}
                  );
                }, icon: Icon(Icons.filter_list_outlined,color: Colors.white,)),
              )
            ],
          ),
        ),
      ),
      body: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        children: <Widget>[
          SizedBox(height: 20,),
          GridCardList(this.widget.itemdata, _searchCtrl.text,CoreSession.currentRange,true,null, )

        ],
      ),
    );
  }
}
