import 'package:flutter/material.dart';

// ignore: must_be_immutable
class CustomeCheckboxDialog extends StatefulWidget {
  Function addRemoveChoise;
  List<String> selectedOptionsTemp = [];
  var questionOptions = [];
  CustomeCheckboxDialog(
      this.questionOptions, this.selectedOptionsTemp, this.addRemoveChoise);
  @override
  _CustomeCheckboxDialog createState() => _CustomeCheckboxDialog();
}

class _CustomeCheckboxDialog extends State<CustomeCheckboxDialog> {
  List<bool> _isChecked = [];
  void initState() {
    super.initState();

    for (var item in widget.questionOptions) {
      bool isSelected = widget.selectedOptionsTemp
              .where((element) => element == item['lovOptionID'].toString())
              .toList()
              .length >
          0;

      _isChecked.add(isSelected);
    }

  }

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      children: [
        Expanded(
          child: ListView(
              shrinkWrap: true,
              padding: EdgeInsets.all(8.0),
              children: [
                ListView.builder(
                  shrinkWrap: true,
                  itemCount: widget.questionOptions.length,
                  itemBuilder: (_, index) {
                    return CheckboxListTile(
                      title: Text(widget.questionOptions[index]['lovName']),
                      value: _isChecked[index],
                      onChanged: (val) {
                        setState(() {
                          _isChecked[index] = val!;
                          widget.addRemoveChoise(
                              widget.questionOptions[index]['lovOptionID'],
                              widget.questionOptions[index]['lovName'],
                              val);
                        });
                      },
                    );
                  },
                ),
              ]),
        ),
      ],
    );
  }
}
