import 'dart:io';
import 'package:flutter/material.dart';
import 'package:image_picker/image_picker.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class ImageQuestion extends StatefulWidget {
  int fieldId;
  Function fillAnswer;
  Function removeImgQuestion;

  ImageQuestion(this.fieldId, this.fillAnswer, this.removeImgQuestion);
  @override
  _ImageQuestionState createState() => _ImageQuestionState();
}

class _ImageQuestionState extends State<ImageQuestion> {
  File? _storedImage;
  final ImagePicker _picker = ImagePicker();
  Future<void> _takePicture(int type) async {
    var source = ImageSource.camera;
    if (type == 2) {
      source = ImageSource.gallery;
    }
    XFile? pickedFile = await _picker.pickImage(
      source: source,
      maxWidth: 600,
    );
    setState(() {
      List<String> files = [];
      List<String> filesName = [];
      if (pickedFile != null) {
        _storedImage = File(pickedFile.path);
        files.add(pickedFile.path);
        filesName.add(pickedFile.name);
        widget.fillAnswer(
            this.widget.fieldId, files, filesName, pickedFile.path.toString());
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(top: 10),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: <Widget>[
          Container(
            width: 100,
            height: 100,
            decoration: BoxDecoration(
              border:
                  Border.all(width: 1, color: Variables.color_primary),
              //borderRadius: BorderRadius.circular(3),
            ),
            child: _storedImage != null
                ? Image.file(
                    _storedImage!,
                    fit: BoxFit.cover,
                    width: double.infinity,
                  )
                : Image.asset(
                    "assets/imgs/no_survey_img.png",
                    fit: BoxFit.cover,
                  ),
          ),
          Container(
            child: Row(
              children: [
                Container(
                  color: Colors.redAccent,
                  child: IconButton(
                    icon: Icon(
                      Icons.close,
                    ),
                    onPressed: () {
                      setState(() {
                        _storedImage = null;
                        this.widget.removeImgQuestion(this.widget.fieldId);
                      });
                    },
                    color: Colors.white,
                  ),
                ),
                SizedBox(width: 10),
                Container(
                  color: Colors.green,
                  child: IconButton(
                    icon: Icon(
                      Icons.add,
                    ),
                    onPressed: () {
                      showModalBottomSheet(
                          context: context,
                          builder: (context) {
                            return Column(
                              mainAxisSize: MainAxisSize.min,
                              children: <Widget>[
                                ListTile(
                                  leading: new Icon(Icons.camera),
                                  title: new Text('Camera'),
                                  onTap: () {
                                    this._takePicture(1);
                                    Navigator.of(context).pop();
                                  },
                                ),
                                ListTile(
                                  leading: new Icon(Icons.photo),
                                  title: new Text('Gallery'),
                                  onTap: () {
                                    this._takePicture(2);
                                    Navigator.of(context).pop();
                                  },
                                ),
                              ],
                            );
                          });
                    },
                    color: Colors.white,
                  ),
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
