import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class MultipleValueQuestion extends StatefulWidget {
  var questionOptions = [];
  int fieldId;
  Function fillAnswer;
  var fieldValue;
  MultipleValueQuestion(
      this.questionOptions, this.fieldId, this.fieldValue, this.fillAnswer) {
    print(fieldValue);
    print("object");
  }

  @override
  _MultipleValueQuestionState createState() => _MultipleValueQuestionState();
}

class _MultipleValueQuestionState extends State<MultipleValueQuestion> {
  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(top: 5),
      child: GestureDetector(
        onTap: () => {
          showModalBottomSheet<void>(
            context: context,
            builder: (BuildContext context) {
              return Column(
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  ListView(
                    shrinkWrap: true,
                    physics: NeverScrollableScrollPhysics(),
                    children: this
                        .widget
                        .questionOptions
                        .map(
                          (e) => ListTile(
                            // leading: new Icon(Icons.photo),
                            title: new Text(
                              e['lovName'],
                              style: TextStyle(
                                fontWeight: widget.fieldValue != null &&
                                        widget.fieldValue != '' &&
                                        int.parse(widget.fieldValue) ==
                                            e['lovOptionID']
                                    ? FontWeight.bold
                                    : FontWeight.normal,
                                fontSize: Variables.headline2FontSize,
                              ),
                            ),
                            onTap: () {
                              setState(() {
                                widget.fieldValue = e['lovOptionID'].toString();
                                print(widget.fieldValue);
                              });
                              widget.fillAnswer(this.widget.fieldId,
                                  e['lovOptionID'].toString());
                              Navigator.pop(context);
                            },
                          ),
                        )
                        .toList(),
                  ),
                ],
              );
            },
          )
        },
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: <Widget>[
            Container(
                child: widget.fieldValue == null || widget.fieldValue == ''
                    ? Text("no-data-found".tr)
                    : Text(widget.questionOptions.firstWhere((e) =>
                        e['lovOptionID'] ==
                        int.parse(widget.fieldValue))['lovName'])),

            // ignore: deprecated_member_use
            Row(
              children: [
                Text(
                  "select".tr,
                  style: TextStyle(
                      color: Colors.grey, fontWeight: FontWeight.bold),
                ),
                Icon(
                  CommunityMaterialIcons.chevron_down,
                  color: Colors.grey,
                )
              ],
            )
          ],
        ),
      ),
    );
  }
}
