import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class NumericQuestion extends StatelessWidget {
  final int fieldId;
  final int fieldSubTypeId;
  final Function fillAnswer;
  NumericQuestion(this.fieldId, this.fillAnswer, this.fieldSubTypeId);
  @override
  Widget build(BuildContext context) {
    return TextFormField(
      keyboardType: TextInputType.number,
      inputFormatters:  this.fieldSubTypeId == 1 ? <TextInputFormatter>[
        // for below version 2 use this
        FilteringTextInputFormatter.allow(RegExp(r'[0-9]')),
        // for version 2 and greater youcan also use this
        FilteringTextInputFormatter.digitsOnly

      ] : [],

      onChanged: (value) {
        fillAnswer(this.fieldId, value.toString());
      },
    );
  }
}
