import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class YesNoQuestion extends StatefulWidget {
  int fieldId;
  Function fillAnswer;
  YesNoQuestion(this.fieldId, this.fillAnswer);
  @override
  _YesNoQuestionState createState() => _YesNoQuestionState();
}

class _YesNoQuestionState extends State<YesNoQuestion> {
  var _groupValue;
  onChangeRadio(var value) {
    setState(() {
      _groupValue = value;
      widget.fillAnswer(widget.fieldId, _groupValue.toString());
    });
  }

  @override
  Widget build(BuildContext context) {
    return Row(
      children: <Widget>[
        new Radio(
          value: 1,
          groupValue: _groupValue,
          onChanged: (value) {
            onChangeRadio(value);
          },
        ),
        GestureDetector(
          child: new Text(
            'yes'.tr,
            // style: new TextStyle(
            //   fontSize: 16.0,
            // ),
            style: TextStyle(
              fontSize: Variables.headline2FontSize,
            ),
          ),
          onTap: () {
            onChangeRadio(1);
          },
        ),
        SizedBox(
          width: 50,
        ),
        new Radio(
          value: 0,
          groupValue: _groupValue,
          onChanged: (value) {
            onChangeRadio(value);
          },
        ),
        GestureDetector(
          child: new Text(
            'no'.tr,
            // style: new TextStyle(
            //   fontSize: 16.0,
            // ),
            style: TextStyle(
              fontSize: Variables.headline2FontSize,
            ),
          ),
          onTap: () {
            onChangeRadio(0);
          },
        ),
      ],
    );
  }
}
