import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/services/survey.service.dart';
import '../../theme/variables.dart';
import './widgets/survey_list_item.dart';
import 'package:echo_app/widgets/no_data.widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:get/get.dart';

class SurveysPage extends StatefulWidget {
  @override
  _SurveysPageState createState() => _SurveysPageState();
}

class _SurveysPageState extends State<SurveysPage> {
  final SurveyService _surveyService = new SurveyService();

  var surveyList = [];

  initState() {
    super.initState();
    populateSurveyList();
  }

  populateSurveyList() async {
    EasyLoading.show(status: 'loading'.tr);
    var response = await _surveyService.getSurveyList();
    EasyLoading.dismiss();

    if (response['status'] == GlobalErrors.Success.index) {
      if (response['data'] != null) {
        setState(() {
          this.surveyList = response['data'];
        });
      } else {
        setState(() {
          this.surveyList = [];
        });
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    
    return SafeArea(
      child: Scaffold(
        appBar: AppBar(
           backgroundColor: Variables.color_primary,
          title: Text("surveys".tr),
          automaticallyImplyLeading: false,
          actions: <Widget>[
            IconButton(
              icon: Icon(Icons.close),
              onPressed: () {
                Navigator.pop(context);
              },
            ),
          ],
        ),
        body: Container(
          padding: EdgeInsets.symmetric(horizontal: 5, vertical: 5),
          child: Column(
            children: <Widget>[
              Expanded(
                child: this.surveyList.length > 0
                    ? ListView.builder(
                        itemBuilder: (ctx, index) {
                          return new SurveyListItem(
                              this.surveyList[index], this.populateSurveyList);
                        },
                        itemCount: this.surveyList.length,
                      )
                    : NoDataWidget(),
              )
            ],
          ),
        ),
      ),
    );
  }
}
