import 'package:badges/badges.dart';
import 'package:bottom_bar_matu/bottom_bar/bottom_bar_bubble.dart';
import 'package:bottom_bar_matu/bottom_bar_item.dart';
import 'package:community_material_icon/community_material_icon.dart';
import 'package:convex_bottom_bar/convex_bottom_bar.dart';
import 'package:echo_app/global/global.dart';
import 'package:echo_app/screens/home_page/home.page.dart';
import 'package:echo_app/screens/my_order/my_order.page.dart';
import 'package:echo_app/screens/notifications/notification.page.dart';
import 'package:echo_app/screens/offers/offers.page.dart';
import 'package:echo_app/services/offers.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';

import 'package:flutter/material.dart';

import '../account_Settings/settings_account.dart';
import '../all_classification_page/all_classification_page.dart';
import '../favourite_page/my_favourite.page.dart';
import 'package:firebase_analytics/firebase_analytics.dart';

// ignore: must_be_immutable
class TapPage extends StatefulWidget {
  int customerId = -1;
  int _selectedIndex = 0;
  var offersList = [];
  static BuildContext? HomeContext;
  TapPage() {
    if (CoreSession.currentOperator['customerId'] != null) {
      customerId = CoreSession.currentOperator['customerId'];
    }

    offersList = OffersService.offers;

  }


  void setContext(context){
    HomeContext = context;
  }
  static void ReloadHome(){
    (HomeContext as Element).markNeedsBuild();
  }

  @override
  _TapPageState createState() => _TapPageState();
  static ValueNotifier<int> enteredValue = ValueNotifier(0);
  static ValueNotifier<int> cartValue = ValueNotifier(0);
}

class _TapPageState extends State<TapPage> with WidgetsBindingObserver {
  String _title = "home";
  TextEditingController _searchCtrl = TextEditingController();
  FirebaseAnalytics analytics = FirebaseAnalytics.instance;

  // ignore: unused_field
  static var str = '';
  var offerList = [];


  List<Widget> _widgetOptions = <Widget>[
    new HomePage(CoreSession.homePageData),
    // new AllCalssificationPage(
    //     CoreSession.homePageData
    //         .firstWhere((element) => element['sectionTypeId'] == 2),
    //     ''),

    new OffersPage(OffersService.offers, true, true),
    new MyFavouritePage(),
    new MyOrderPage(),
    new SettingAccount(),
  ];


  @override
  void didChangeAppLifecycleState(AppLifecycleState state) {
    switch (state) {
      case AppLifecycleState.resumed:
        // widget is resumed
        setState(() {});
        break;
      case AppLifecycleState.inactive:
        // widget is inactive
        break;
      case AppLifecycleState.paused:
        // widget is paused
        break;
      case AppLifecycleState.detached:
        // widget is detached
        break;
    }
  }

  @override
  void didUpdateWidget(TapPage oldWidget) {
    this.widget._selectedIndex = oldWidget._selectedIndex;
    print('16');
  }

  @override
  initState() {
    FirebaseMessaging.instance.getInitialMessage().then((message) {
      if (message != null) {
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (context) => NotificationPage(),
          ),
        );
      }
    });

    FirebaseMessaging.onMessageOpenedApp.listen(
      (message) {
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (context) => NotificationPage(),
          ),
        );
      },
    );
    WidgetsBinding.instance!.addObserver(this);
    super.initState();
  }

  @override
  void dispose() {
    WidgetsBinding.instance!.removeObserver(this);

    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    this.widget.setContext(context);
    return SafeArea(
      child: WillPopScope(
        onWillPop: () async {
          await CoreSession.showYesNoDialog(context, () {
            SystemNavigator.pop();
          }, 'close-app'.tr);
          return false;
        },
        child: Scaffold(
          body: Center(
            child: _widgetOptions.elementAt(this.widget._selectedIndex),
          ),
          bottomNavigationBar: Container(
            child: ClipRRect(
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(30.0),
                topRight: Radius.circular(30.0),
              ),
              child: Directionality(
                textDirection: CoreSession.selectedLanguageId == 2? TextDirection.rtl : TextDirection.ltr,
                child: BottomBarBubble(
                  bubbleSize: 0,
                  color: Variables.color_primary,
                  items: [
                    BottomBarItem(
                      // iconData: Icons.home,
                      iconBuilder: (color) => Image.asset(
                          'assets/imgs/home_icon/0.png',
                          color: color,
                          height: 100,
                          width: 100),
                      label: 'main'.tr,
                      labelTextStyle: TextStyle(
                        fontSize: 12,
                        color: Colors.black,
                      ),
                    ),
                    BottomBarItem(
                      iconBuilder: (color) => Image.asset(
                          'assets/imgs/home_icon/1.png',
                          color: color,
                          height: 33,
                          width: 30),
                      label: 'location'.tr,
                      labelTextStyle: TextStyle(
                        fontSize: 12,
                        color: Colors.black,
                      ),
                    ),
                    BottomBarItem(
                      iconBuilder: (color) => Image.asset(
                          'assets/imgs/home_icon/2.png',
                          color: color,
                          height: 33,
                          width: 30),
                      label: 'favourite'.tr,
                      labelTextStyle: TextStyle(
                        fontSize: 12,
                        color: Colors.black,
                      ),
                    ),
                    BottomBarItem(
                      labelTextStyle: TextStyle(
                        fontSize: 12,
                        color: Colors.black,
                      ),
                      iconBuilder: (color) => Image.asset(
                          'assets/imgs/home_icon/3.png',
                          color: color,
                          height: 33,
                          width: 30),
                      label: 'cart'.tr,
                    ),
                    BottomBarItem(
                      iconBuilder: (color) => Image.asset(
                          'assets/imgs/home_icon/4.png',
                          color: color,
                          height: 33,
                          width: 30),
                      label: 'more'.tr,
                      labelTextStyle: TextStyle(
                        fontSize: 12,
                        color: Colors.black,
                      ),
                    ),
                  ],
                  selectedIndex: this.widget._selectedIndex,
                  onSelect: (i) {
                    _searchCtrl.text = '';
                    this.widget._selectedIndex = i;
                    if (i == 0) {
                      this._title = "home";
                    } else {
                      this._title = "offers";
                    }
                    setState(() {});
                  },
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}
