import 'package:echo_app/enums/alert_types.dart';
import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/widgets/alert.widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:get/get.dart';
import 'package:rflutter_alert/rflutter_alert.dart';

import '../../theme/variables.dart';
import '../tap_page/tap.page.dart';

// ignore: must_be_immutable
class VendorsList extends StatelessWidget {
  var userName = '';
  var password = '';
  bool loading = false;
  VendorsList(this.userName, this.password);
  @override
  Widget build(BuildContext context) {
    void _login(organizationId) async {
      EasyLoading.show(status: 'loading'.tr);
      var response =
          await CoreSession.login(userName, password, organizationId);
      var result = response['result'];
      if (result == GlobalErrors.Success.index) {
        EasyLoading.dismiss();
        loading = false;
        Navigator.pushReplacement(
          context,
          MaterialPageRoute(
            builder: (context) => TapPage(),
          ),
        );
      } else if (result == GlobalErrors.VersionNotMatch.index) {
        EasyLoading.dismiss();
        loading = false;
        Alert(
          context: context,
          type: AlertType.error,
          useRootNavigator: true,
          title: "message".tr,
          desc: "new-version-found".tr,
          buttons: [
            DialogButton(
              color: Colors.white,
              child: Text(
                "ok".tr,
                style: TextStyle(color: Colors.green, fontSize: 20),
              ),
              onPressed: () => {
                Navigator.of(context, rootNavigator: true).pop(),
              },
              width: 120,
            )
          ],
        ).show();
      } else {
        loading = false;
        EasyLoading.dismiss();
        EasyLoading.showError("error".tr);
      }
    }

    return Scaffold(
      appBar: AppBar(
         backgroundColor: Variables.color_primary,
        title: Text("vendors-list".tr),
        automaticallyImplyLeading: false,
        actions: <Widget>[
          IconButton(
            icon: Icon(Icons.close),
            onPressed: () {
              Navigator.pop(context);
            },
          ),
        ],
      ),
      body: Column(
        children: [
          AlertWidget(AlertTypes.Info, "select-vendor-message"),
          Expanded(
            child: Padding(
              padding: const EdgeInsets.symmetric(horizontal: 10),
              child: ListView.builder(
                  itemBuilder: (context, index) {
                    return GestureDetector(
                        child: Card(
                          elevation: 4,
                          margin:
                              EdgeInsets.symmetric(vertical: 5, horizontal: 5),
                          child: Container(
                            padding: EdgeInsets.symmetric(
                                vertical: 10, horizontal: 10),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Text(CoreSession.organizationList[index]
                                    ['organizationCodeName']),
                                CoreSession.selectedLanguageId == 2
                                    ? Icon(Icons.keyboard_arrow_left)
                                    : Icon(Icons.keyboard_arrow_right)
                              ],
                            ),
                          ),
                        ),
                        onTap: () {
                          if (!loading) {
                            loading = true;
                            var organizationId = CoreSession
                                .organizationList[index]['organizationId'];
                            _login(organizationId);
                          }
                        });
                  },
                  itemCount: CoreSession.organizationList.length),
            ),
          )
        ],
      ),
    );
  }
}
