import 'dart:convert';
import 'package:dio/dio.dart';
import 'package:echo_app/global/global.dart';
import 'package:echo_app/models/user.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:http/http.dart' as http;

class CustomerService {
  var _url = '';
  Map<String, String>? _httpOptions;
 
  CustomerService() {
    this._url = CoreSession.api + "API/EchoCustomer/";

    this._httpOptions = {
      'Content-Type': 'application/json',
      "LanguageId": CoreSession.selectedLanguageId.toString(),
    };
  }

  getCustomerSOA() async {
    final String urlValue = this._url + "GetCustomerSOA";
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  createAccount(UserModel user) async {
    final String urlValue = this._url + "SaveNewCustomer";
    // var body = json.encode(user);
    var body = json.encode({
      'username': user.userName,
      'password': user.password,
      'customerName': user.customerName,
      'phoneNumber': user.phoneNumber,
      'tradeLicenseNumber': user.tradeLicenseNumber,
      'address': user.address,
      'longitude': user.longitude,
      'latitude': user.latitude,
      // 'identification': user.identification,
      'deviceToken': user.deviceToken,
      'countryId': user.countryId,
      'stateId': user.stateId,
      'cityId': user.cityId,
      'areaId': user.areaId,
      'streetId': user.streetId,
    });
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: _httpOptions,
        body: body,
      );

      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  uploadIdentifications(List<String> filePathes, List<String> fileNames,
      int customerId, int outletId) async {
    final String urlValue = this._url + "UploadCustomerIdentification";

    var formData = new FormData();
    for (int index = 0; index < fileNames.length; index++) {
      String path = filePathes[index];
      String name = customerId.toString() +
          "|" +
          outletId.toString() +
          "|" +
          fileNames[index];

      formData.files.addAll([
        MapEntry("file", await MultipartFile.fromFile(path, filename: name)),
      ]);
    }
    var response = await Dio().post(urlValue, data: formData);
    print(response);
  }
}
