import 'dart:convert';

import 'package:echo_app/global/global.dart';
import 'package:echo_app/models/operator.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:http/http.dart' as http;

class GeneralService {
  String _url = "";
  int languageId = 1;
  GeneralService() {
    this._url = CoreSession.api + "API/EchoGeneral/";
  }

  Future<dynamic> getCustomerAppProfileData() async {
    final String urlValue = this._url + "GetCustomerAppProfileData";
    try {
      final response =
          await http.get(Uri.parse(urlValue), headers: Global.httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> getAppProperties() async {
    final String urlValue = this._url + 'GetCustomerAppProperties';
    try {
      final response =
          await http.get(Uri.parse(urlValue), headers: Global.httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> getCompanyDetails() async {
    final String urlValue = this._url + 'GetCompanyDetails';
    try {
      final response =
          await http.get(Uri.parse(urlValue), headers: Global.httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> submitContactUS(subject, message) async {
    final String urlValue = this._url + 'SaveContactUsMessage';
    var body = jsonEncode({
      'subject': subject,
      'message': message,
    });

    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> changePassword(OperatorModel operatorModel) async {
    final String urlValue = this._url + 'ChangePassword';
    var body = jsonEncode({
      'password': operatorModel.password,
      'username': operatorModel.username,
    });
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> updateProfileData(OperatorCustomerModel operatorModel) async {
    final String urlValue = this._url + 'UpdateCustomerProfileData';

    var body = jsonEncode({
      'address': operatorModel.address,
      'phone': operatorModel.phone,
      'longitude': operatorModel.longitude,
      'latitude': operatorModel.latitude,
    });
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  getDashboards() async {
    final String urlValue = this._url + 'GetCustomerAppDashboards';
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
      );
      return json.decode(response.body)['data'];
    } catch (error) {
      print(error);
    }
  }
  getCustomerAppFAQs() async {
    final String urlValue = this._url + 'GetCustomerAppFAQs';
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }
}
