
import 'package:echo_app/languages/ar_AE.dart';
import 'package:echo_app/languages/en_US.dart';
import 'package:get/get.dart';
import 'package:flutter/material.dart';

class LocalizationService extends Translations {
  static final local = Locale('en', 'US');
  static final fallBackLocale = Locale('en', 'US');

  static final langs = ['English', 'Arabic'];
  static final locals = [Locale('en', 'US'), Locale('ar', 'AE')];

  @override
  Map<String, Map<String, String>> get keys => {
        'en_US': enUS,
        'ar_AE': arAE,
      };

  void changeLocale(var languageId) {
    final locale = getLocaleFromLanguage(languageId);
    Get.updateLocale(locale);
  }

  Locale getLocaleFromLanguage(var languageId) {
    return locals[languageId - 1];
  }
}
