import 'dart:convert';
import 'dart:io';

import 'package:echo_app/global/global.dart';

import '../shared/core.session.dart';
import 'package:http/http.dart' as http;

class OrderService {
  var _url = '';
  var offers = [];
  bool offersUpdatedSuccesfully = false;

  OrderService() {
    this._url = CoreSession.api + "API/EchoOrder/";
  }

  checkOutOrder(addedItems) async {
    final String urlValue = this._url + "CheckOutOrder";
    var body = json.encode(addedItems);
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  saveOrder(order) async {
    final String urlValue = this._url + 'SaveOrder';
    var body = json.encode(order);
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }
  callPaymentGatewayLahza(String email, String amount, String mobileNo, String customerName) async {
    try {
      print('Call payment gateway');
      final Map<String, String> httpOptions = {
        HttpHeaders.authorizationHeader: "Bearer " + CoreSession.LahzaConfigKey,
        HttpHeaders.contentTypeHeader: 'application/json'
      };
      var body = json.encode({"email": email, "amount": amount, "currency": "ILS", "mobile": mobileNo, "first_name": customerName,
      "metadata":{"cancel_action": "https://cancelpayment.com"}});
      final response = await http.post(
          Uri.parse("https://api.lahza.io/transaction/initialize"),
          headers: httpOptions,
          body: body
      );
      return json.decode(response.body);
    }
    catch (error) {
      print(error);
    }
  }
  callPaymentGatewayLahzaVerifyPayment (String refNumber) async{
    try {
      final Map<String, String> httpOptions = {
        HttpHeaders.authorizationHeader: "Bearer " + CoreSession.LahzaConfigKey,
        HttpHeaders.contentTypeHeader: 'application/json'
      };
      final reference = refNumber;
      final response = await http.get(
          Uri.parse("https://api.lahza.io/transaction/verify/$reference"),
          headers: httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }
  Future<dynamic> getOrderHistory(bool sortDesc) async {
    final String urlValue = this._url + "GetOrderHistory";
    try {
      // String parameterss = '?pageNumber=${0}&pageSize=${10000}&descendingSort={true}';
      final response = await http.get(
          Uri.parse(urlValue +
              '?pageNumber=${0}&pageSize=${10000}&descendingSort=$sortDesc'),
          headers: Global.httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  cancelOrder(order) async {
    final String urlValue = this._url + 'CancelOrder';
    var body = json.encode(order);
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> getOrderDetailsForView(String orderId) async {
    final String urlValue = this._url + "GetOrderDetails";
    try {
      final response = await http.get(
          Uri.parse(urlValue + '?orderId=$orderId&getStatus${false}'),
          headers: Global.httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> getOrderDetailsForReorder(String orderId) async {
    final String urlValue = this._url + "GetOrderDetailsForReorderNew";
    try {
      final response = await http.get(Uri.parse(urlValue + '?orderId=$orderId'),
          headers: Global.httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }
}
