import 'package:dio/dio.dart';
import 'package:echo_app/global/global.dart';
import 'package:echo_app/shared/core.session.dart';
import 'dart:convert';
import 'package:http/http.dart' as http;

class SurveyService {
  var _url = '';
  var offers = [];
  SurveyService() {
    this._url = CoreSession.api + "API/EchoSurvey/";
  }

  Future<dynamic> getSurveyList() async {
    final String urlValue = this._url + "GetCustomerSurveyList";
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> getSurveyQuestions(int surveyId) async {
    final String urlValue =
        this._url + "GetSurveyQuestions?surveyId=" + surveyId.toString();
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> saveSurveyAnswers(answers) async {
    final String urlValue = this._url + "SaveSurveyAnswers";
    var body = jsonEncode(answers);
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  uploadAnswersImages(FormData formData) async {
    final String urlValue = this._url + "UploadAnswersImages";
    Dio dio = new Dio();
    dio.options.headers['content-Type'] = 'application/json';
    dio.options.headers["authorization"] = "${Global.token}";
    var response = await dio.post(urlValue, data: formData);
    print(response);
  }

  Future<dynamic> getCustomerSurveyAfterSaveOrder() async {
    final String urlValue = this._url + "GetCustomerSurveyAfterSaveOrder";
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }
}
