import 'package:echo_app/services/localization.service.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class TestLang extends StatefulWidget {
  const TestLang({Key? key}) : super(key: key);

  @override
  _TestLangState createState() => _TestLangState();
}

class _TestLangState extends State<TestLang> {
  String lng = "English";
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Variables.color_primary,
        title: Text("Flutter Multi Lang App"),
        elevation: 0,
        
      ),
      body: Center(child: _uiWidget()),
    );
  }

  Widget _uiWidget() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        Text(
          "hello".tr,
          style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
        ),
        Row(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text(
              "Language",
              style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
            ),
            Text(" "),
            new DropdownButton<String>(
              items: LocalizationService.langs.map(
                (String value) {
                  return new DropdownMenuItem<String>(
                    value: value,
                    child: new Text(value),
                  );
                },
              ).toList(),
              value: this.lng,
              underline: Container(
                color: Colors.transparent,
              ),
              isExpanded: false,
              onChanged: (newVal) {
                setState(() {
                  this.lng = newVal!;
                  LocalizationService().changeLocale(this.lng);
                });
              },
            )
          ],
        )
      ],
    );
  }
}
