import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../theme/variables.dart';

// ignore: must_be_immutable
class ICashAdd extends StatelessWidget {
  ICashAdd();
  int defaultSelect = 0;
  var listvar = ['20' , '50', '100','500'];
  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        border: Border(
          top: BorderSide(color: Colors.grey, width: 1),
        ),
      ),
      child: Column(
        children: [
          SizedBox(height: 20,),
          Text("Add Cash",style: TextStyle(color: Variables.color_primary, fontSize: Variables.headline1FontSize),),
          SizedBox(height: 20,),

          Padding(
            padding: const EdgeInsets.all(8.0),
            child: SingleChildScrollView(
              scrollDirection: Axis.horizontal,
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Wrap(
                    spacing: 10.0,
                    children: List<Widget>.generate(
                      listvar.length,
                          (int index) {
                        return ChoiceChip(
                          selectedColor: Variables.color_primary,
                          label: Text(listvar[index] +' ' + CoreSession.currentOperator['currencyCode'],style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          selected: defaultSelect == index,
                          onSelected: (bool selected) {
                            defaultSelect = index;
                            (context as Element).markNeedsBuild();
                          },
                        );
                      },
                    ).toList(),
                  ),
                ],
              ),
            ),
          ),
          Divider(color: Colors.grey,),
          Row(
            children: [
              SizedBox(width: 20,),
              Text("net-total".tr,style:
              TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
              Spacer(),
              Text(double.parse(listvar[defaultSelect]).toString() +' ' + CoreSession.currentOperator['currencyCode']),
              SizedBox(width: 20,)
            ],
          ),
          SizedBox(height: 20,),
          Row(
            children: [
              SizedBox(width: 20,),
              Text("cost".tr,style:
              TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
              Spacer(),
              Text((double. parse(listvar[defaultSelect])  *0.9).toString() +' ' + CoreSession.currentOperator['currencyCode']),
              SizedBox(width: 20,)
            ],
          ),
          SizedBox(height: 20,),
          Row(
            children: [
              Spacer(),
              ElevatedButton(
                onPressed: () {
                  Navigator.pop(context);
                },
                child: Text("Buy"),
                style: ElevatedButton.styleFrom(
                  backgroundColor: Variables.color_primary,
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(20),
                  ),
                ),
              ),
              Spacer(),
            ],
          ),
        ],
      ),
    );
  }
}
