import 'package:echo_app/enums/echo-custome-home-page-types.dart';
import 'package:echo_app/enums/echo_special_items_types.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class ClassificationCardWidget extends StatelessWidget {
  var id = -1;
  var index = 0;
  var sectionTypeId = -1;
  var pathStr = '';
  var name = '';
  var selected = false;
  Function onClickCard;
  ClassificationCardWidget(this.id, this.sectionTypeId, this.name,
      this.selected, this.onClickCard, this.index) {
    if (EchoCustomeHomePageTypes.Brands.index == this.sectionTypeId)
      pathStr = 'brand';

    if (EchoCustomeHomePageTypes.Categories.index == this.sectionTypeId)
      pathStr = 'category';

    if (EchoCustomeHomePageTypes.MasterGroupes.index == this.sectionTypeId)
      pathStr = 'itemGroup';
    if (EchoCustomeHomePageTypes.Special.index == this.sectionTypeId) {
      if (this.id == EchoSpecialItemsTypes.IsNew.index) name = 'Desc_IsNew'.tr;
      if (this.id == EchoSpecialItemsTypes.IsPowerSKU.index) name = 'Desc_isPowerSKU'.tr;
      if (this.id == EchoSpecialItemsTypes.IsInitiative.index) name = 'Desc_Is_Initiative'.tr;
    }
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 100,
      width: 100,
      alignment: Alignment.bottomRight,
      child: GestureDetector(
        onTap: () {
          this.onClickCard(this.index);
        },
        child: Card(
          elevation: 2,
          shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(5),
          ),
          shadowColor: Colors.black12,
          child: Container(
            decoration: BoxDecoration(
              border: Border.all(
                color: this.selected ? Colors.redAccent : Colors.white,
              ),
              borderRadius: BorderRadius.circular(5),
            ),
            child: Column(
              children: <Widget>[
                Expanded(
                  flex: 2,
                  child: Container(
                    padding: EdgeInsets.all(2),
                    height: double.infinity,
                    width: double.infinity,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(5),
                      child: EchoCustomeHomePageTypes.Special.index ==
                              this.sectionTypeId
                          ? Image.asset(this.id ==
                                  EchoSpecialItemsTypes.IsNew.index
                              ? 'assets/imgs/default/new.png'
                              : this.id ==
                                      EchoSpecialItemsTypes.IsPowerSKU.index
                                  ? 'assets/imgs/default/sku.png'
                                  : this.id ==
                                          EchoSpecialItemsTypes
                                              .IsInitiative.index
                                      ? 'assets/imgs/default/initiative.png'
                                      : 'assets/imgs/default/most-selling.png')
                          : Image.network(
                              CoreSession.imagePath +
                                  this.pathStr +
                                  '/' +
                                  this.id.toString() +
                                  '.png',
                              errorBuilder: (context, error, stackTrace) {
                                return Image.network(
                                    CoreSession.imagePath + '/no-image.png');
                              },
                              fit: BoxFit.contain,
                            ),
                    ),
                  ),
                ),
                // if (EchoCustomeHomePageTypes.Special.index !=
                //     this.sectionTypeId)
                Expanded(
                  child: Padding(
                    padding: EdgeInsets.all(2),
                    child: Center(
                      child: Text(
                        // ignore: unnecessary_null_comparison
                        this.name != null ? name : '',
                        overflow: TextOverflow.ellipsis,
                        softWrap: false,
                        maxLines: 1,
                        style: TextStyle(
                          fontSize: Variables.headline5FontSize,
                          fontWeight: FontWeight.normal,
                        ),
                      ),
                    ),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
    );
  }
}
