import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

// ignore: must_be_immutable
class CustomeDialogWidget extends StatelessWidget {
  int count = 0;
  var quantityController = TextEditingController()..text = '0';

  final String title = 'Item101 - 101 (PC)',
      descriptions =
          'Lorem Ipsum is simply dummy text of the printing and typesetting industry.',
      text = '';
      String quanText ='';

  @override
  Widget build(BuildContext context) {
    return Dialog(
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(Constants.padding),
      ),
      elevation: 0,
      backgroundColor: Colors.transparent,
      child: contentBox(context),
    );
  }

  contentBox(context) {
    Size size = MediaQuery.of(context).size;
    return Stack(
      children: <Widget>[
        Container(
          margin: EdgeInsets.only(top: Constants.avatarRadius),
          decoration: BoxDecoration(
              shape: BoxShape.rectangle,
              color: Colors.white,
              borderRadius: BorderRadius.circular(Constants.padding),
              boxShadow: [
                BoxShadow(
                    color: Colors.black, offset: Offset(0, 10), blurRadius: 10),
              ]),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: <Widget>[
              Container(
                height: 200,
                decoration: new BoxDecoration(
                    borderRadius: BorderRadius.only(
                        topRight: Radius.circular(Constants.padding),
                        topLeft: Radius.circular(Constants.padding))),
                child: ClipRRect(
                  borderRadius: BorderRadius.vertical(
                      top: Radius.circular(Constants.padding)),
                  child: Image.asset(
                    "assets/imgs/cat1.jpg",
                    fit: BoxFit.cover,
                  ),
                ),
              ),
              SizedBox(
                height: 10,
              ),
              Text(
                this.title,
                style: Theme.of(context).textTheme.bodyLarge,
                textAlign: TextAlign.center,
              ),
              Text(
                this.descriptions,
                //style: Theme.of(context).textTheme.headline2,
                textAlign: TextAlign.center,
              ),
              SizedBox(
                height: 10,
              ),
              Container(
                padding: EdgeInsets.symmetric(horizontal: 20),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Container(
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: <Widget>[
                          Container(
                              child: Row(
                            children: [
                              Text(
                                "Price: ",
                                style: TextStyle(fontWeight: FontWeight.bold),
                              ),
                              Text("10.05")
                            ],
                          )),
                          Container(
                              child: Row(
                            children: [
                              Text(
                                "Tax: ",
                                style: TextStyle(fontWeight: FontWeight.bold),
                              ),
                              Text("10.05")
                            ],
                          )),
                          Container(
                              child: Row(
                            children: [
                              Text(
                                "Total: ",
                                style: TextStyle(fontWeight: FontWeight.bold),
                              ),
                              Text("102")
                            ],
                          ))
                        ],
                      ),
                    ),
                  ],
                ),
              ),
              SizedBox(
                height: 10,
              ),
              Container(
                padding: EdgeInsets.symmetric(horizontal: 10),
                child: new Wrap(
                  children: [
                    Container(
                      height: 30,
                      color: Colors.grey,
                      child: IconButton(
                        padding: EdgeInsets.zero,
                        icon: Icon(Icons.remove),
                        color: Colors.white,
                        onPressed: () {
                          if (count > 0) {
                            count--;
                            quantityController..text = count.toString();
                          }
                        },
                      ),
                    ),
                    Container(
                      width: size.width - 250,
                      height: 30,
                      //padding: EdgeInsets.symmetric(horizontal: 5),
                      child: TextField(
                        keyboardType: TextInputType.number,
                        inputFormatters: <TextInputFormatter>[
                          FilteringTextInputFormatter.digitsOnly
                        ],
                        style: TextStyle(fontSize: 15.0, color: Colors.black),
                        textAlign: TextAlign.center,
                        controller: quantityController,
                        // onChanged: (val) {
                        //   if (val.length <= 5) {
                        //     quanText = val;
                        //   } else {
                        //     quantityController.value = new TextEditingValue(
                        //         text: quanText,
                        //         selection: new TextSelection(
                        //             baseOffset: 5,
                        //             extentOffset: 5,
                        //             affinity: TextAffinity.downstream,
                        //             isDirectional: false),
                        //         composing: new TextRange(start: 0, end: 5));
                        //   }
                        //   quantityController.text = quanText;
                        // },
                        decoration: new InputDecoration(
                            focusedBorder: OutlineInputBorder(
                              borderSide: BorderSide(color: Colors.green),
                              borderRadius: const BorderRadius.all(
                                const Radius.circular(0),
                              ),
                            ),
                            border: new OutlineInputBorder(
                              borderRadius: const BorderRadius.all(
                                const Radius.circular(0),
                              ),
                            ),
                            filled: true,
                            hintStyle: new TextStyle(color: Colors.grey),
                            hintText: "0",
                            fillColor: Colors.white70,
                            contentPadding: EdgeInsets.symmetric(vertical: 5)),
                      ),
                    ),
                    Container(
                      height: 30,
                      color: Colors.green,
                      child: IconButton(
                        padding: EdgeInsets.zero,
                        icon: Icon(Icons.add),
                        color: Colors.white,
                        onPressed: () {
                          count++;
                          quantityController..text = count.toString();
                        },
                      ),
                    ),
                  ],
                ),
              ),
              SizedBox(
                height: 10,
              ),
              Container(
                child: ElevatedButton.icon(
                  icon: Icon(
                    Icons.save_outlined,
                    size: 15,
                  ),
                  onPressed: () {},
                  label: Text("Save"),
                ),
              ),
              SizedBox(
                height: 20,
              ),
            ],
          ),
        ),
        // Positioned(
        //   left: Constants.padding,
        //   right: Constants.padding,
        //   child: new Container(
        //      width: 100.0,
        //      height: 100.0,
        //      decoration: new BoxDecoration(
        //        color: const Color(0xff7c94b6),
        //        image: new DecorationImage(
        //          image: new AssetImage('assets/imgs/1.png'),
        //          fit: BoxFit.cover,
        //        ),
        //        borderRadius: new BorderRadius.all(new Radius.circular(10.0)),
        //        border: new Border.all(
        //          color: Colors.black,
        //          width: 1.0,
        //        ),
        //      ),
        //    ),
        // ),
      ],
    );
  }
}

class Constants {
  Constants._();
  static const double padding = 15;
  static const double avatarRadius = 45;
}
