import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class AddRemoveItemBox extends StatefulWidget {
  Function onQtyChanged;
  var pack;
  int index;
  final quantityController = TextEditingController();

  AddRemoveItemBox(this.onQtyChanged, this.pack, this.index) {
    var i = (this.pack['requiredQty'] ?? 0.00).toStringAsFixed(0);
    quantityController.text = i;
    quantityController.selection = TextSelection.fromPosition(
        TextPosition(offset: quantityController.text.length));
  }

  @override
  _AddRemoveItemBoxState createState() => _AddRemoveItemBoxState();
}

class _AddRemoveItemBoxState extends State<AddRemoveItemBox> {
  @override
  void initState() {
    widget.quantityController.addListener(() => {
          widget.onQtyChanged(this.widget.pack, this.widget.index,
              int.parse(widget.quantityController.text)).then((c){
            setState(() {});
          })
        });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Container(
        child: Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        new Wrap(
          children: [
            Container(
              height: 28,
              width: 28,
              decoration: BoxDecoration(
                color: Colors.white, // Background color of the circle
                shape: BoxShape.circle, // Making the shape circular
              ),
              child: IconButton(
                padding: EdgeInsets.zero,
                icon: Icon(Icons.remove,color: Colors.grey,),
                color: Colors.white,
                onPressed: () {
                  this
                      .widget
                      .onQtyChanged(this.widget.pack, this.widget.index, '-1',false).then((c){
                  setState(() {});
                  });

                  // if (count > 0) {
                  //   count--;
                  //   quantityController..text = count.toString();
                  // }
                },
              ),
            ),
            Container(
              width: size.width >= 576 ? 150 : 40,
              height: 28,
              margin: EdgeInsets.symmetric(horizontal: 1),
              //padding: EdgeInsets.symmetric(horizontal: 5),
              child: TextField(
                enableInteractiveSelection: false,
                keyboardType: TextInputType.number,
                maxLength: 4,
                inputFormatters: <TextInputFormatter>[
                  FilteringTextInputFormatter.digitsOnly
                ],
                style: TextStyle(
                  fontSize: 15.0,
                  color: Colors.black,
                  fontWeight: FontWeight.bold,
                ),
                textAlign: TextAlign.center,
                controller: widget.quantityController,
                // maxLength: 2,
                // maxLengthEnforced: true,
                onChanged: (text) {
                  this.widget.onQtyChanged(this.widget.pack, this.widget.index, text,true).then((c){
                    setState(() {});
                  });
                },
                decoration: new InputDecoration(
                  counterText: '',
                  enabledBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                      color: Colors.white,
                    ),
                  ),
                  border: new OutlineInputBorder(
                    borderSide: new BorderSide(color: Colors.red),
                    borderRadius: const BorderRadius.all(
                      const Radius.circular(0),
                    ),
                  ),
                  focusedBorder: OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.white),
                    borderRadius: const BorderRadius.all(
                      const Radius.circular(0),
                    ),
                  ),
                  filled: true,
                  hintStyle: new TextStyle(color: Colors.grey),
                  hintText: "0",
                  fillColor: Colors.white70,
                  contentPadding: EdgeInsets.symmetric(vertical: 5),
                ),
              ),
            ),
            Container(
              height: 28,
              width: 28,
              decoration: BoxDecoration(
                color: Variables.color_primary, // Background color of the circle
                shape: BoxShape.circle, // Making the shape circular
              ),
              child: IconButton(
                padding: EdgeInsets.zero,
                icon: Icon(Icons.add),
                color: Colors.white,
                onPressed: () {
                  if (widget.quantityController.text.toString() =='9999')
                    return;
                  this
                      .widget
                      .onQtyChanged(this.widget.pack, this.widget.index, '1' , false).then((c) {
                    setState(() {});
                  });
                  // count++;
                  // quantityController..text = count.toString();
                },
              ),
            ),
          ],
        ),
      ],
    ));
  }
}
