import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class GeneralTextFormFieldWidget extends StatefulWidget {
  TextEditingController controller;
  String labelText;
  IconData? icon;
  var constPadding = EdgeInsets.all(0);
  bool enabled = false;
  bool obscureText = false;
  bool isRequired = false;
  String? errorMessage;
  Function? onFieldSubmitted;
  Function? onValueChanged;
  FocusNode? focusNode;
  int maxLines = 1;
  bool fullBordersSide = false;
  bool hasError = false;
  bool normalText = false;
  double fontsize = 15;
  TextInputType textInputType = TextInputType.text;
  bool showObscureText = false;

// keyboardType: TextInputType.number
  // ignore: avoid_init_to_null
  GeneralTextFormFieldWidget(
      this.labelText,
      this.controller,
      this.isRequired,
      this.errorMessage,
      this.enabled,
      this.obscureText,
      this.icon,
      this.onFieldSubmitted,
      this.onValueChanged,
      this.constPadding,
      this.focusNode,
      this.maxLines,
      this.fullBordersSide,
      this.hasError,
      this.normalText,
      this.fontsize,
      this.textInputType);

  @override
  State<GeneralTextFormFieldWidget> createState() =>
      _GeneralTextFormFieldWidgetState();
}

class _GeneralTextFormFieldWidgetState
    extends State<GeneralTextFormFieldWidget> {

  @override
  initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    var _textStyle = TextStyle(color: this.widget.normalText  ? Colors.black : Variables.color_primary);
    var _underlineInputBorder = UnderlineInputBorder(
      borderSide: this.widget.normalText  ?   BorderSide(color: Colors.grey)  : (this.widget.hasError
          ? BorderSide(color: Colors.redAccent)
          : BorderSide(color: Colors.white)),
    );
    var _outlineInputBorder = OutlineInputBorder(
      borderSide: this.widget.normalText  ?   BorderSide(color: Colors.grey)  : (this.widget.hasError
          ? BorderSide(color: Colors.redAccent)
          : BorderSide(color: Colors.white)),
    );
    return Container(
      color: Colors.white,
      padding: widget.constPadding,
      child: TextFormField(
        enabled: this.widget.enabled,
        controller: widget.controller,
        maxLines: this.widget.maxLines,
        style: TextStyle(fontSize: this.widget.fontsize),
        keyboardType: this.widget.textInputType,
        decoration: this.widget.icon != null
            ? InputDecoration(
                contentPadding:
                    new EdgeInsets.symmetric(vertical: 0, horizontal: 10.0),
                border:
                    OutlineInputBorder(borderRadius: BorderRadius.circular(0)),
                prefixIcon: Icon(
                  this.widget.icon,
                  color: Variables.color_primary,
                ),
                suffixIcon: widget.obscureText ?
                IconButton(
                  icon: Icon(
                    !widget.showObscureText
                        ? Icons.visibility_outlined
                        : Icons.visibility_off_outlined,
                    size: 15.0,
                    color: Variables.color_primary,
                  ),
                  onPressed: () {
                    setState(() {
                      this.widget.showObscureText = !this.widget.showObscureText;
                    });
                  },
                ) : null,
                labelStyle: _textStyle,
                enabledBorder: this.widget.fullBordersSide
                    ? _outlineInputBorder
                    : _underlineInputBorder,
                focusedBorder: this.widget.fullBordersSide
                    ? _outlineInputBorder
                    : _underlineInputBorder,
                disabledBorder: this.widget.fullBordersSide
                    ? _outlineInputBorder
                    : _underlineInputBorder,
                labelText: this.widget.labelText.tr,
              )
            : InputDecoration(
                fillColor:  Colors.white,

                filled: this.widget.normalText ?  true : false,
                contentPadding:
                    new EdgeInsets.symmetric(vertical: 0, horizontal: 10.0),
                border:
                    OutlineInputBorder(borderRadius: BorderRadius.circular(0)),
                labelStyle: _textStyle,
                enabledBorder: this.widget.fullBordersSide
                    ? _outlineInputBorder
                    : _underlineInputBorder,
                focusedBorder: this.widget.fullBordersSide
                    ? _outlineInputBorder
                    : _underlineInputBorder,
                disabledBorder: this.widget.fullBordersSide
                    ? _outlineInputBorder
                    : _underlineInputBorder,
                labelText: this.widget.labelText.tr,
              ),
        focusNode: this.widget.focusNode,
        obscureText: widget.showObscureText ? false : widget.obscureText,

        onFieldSubmitted: (_) {
          if (this.widget.onFieldSubmitted != null) {
            this.widget.onFieldSubmitted!();
          }
        },
        onChanged: (value) {
          if (widget.isRequired) {
            setState(() {
              if (value == '') {
                widget.hasError = true;
              } else {
                widget.hasError = false;
              }
            });
          }
          if (this.widget.onValueChanged != null) {
            this.widget.onValueChanged!(value);
          }
        },
        validator: (value) {
          if (this.widget.isRequired &&
              value!.isEmpty &&
              widget.controller.text.isEmpty) {
            return widget.errorMessage;
          }
          return null;
        },
      ),
    );
  }
}
