import 'package:echo_app/services/login.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';

// ignore: must_be_immutable
class LanguagesRadioBbtnListWidget extends StatefulWidget {
  int languageId = 1;
  @override
  State<LanguagesRadioBbtnListWidget> createState() =>
      _LanguagesRadioBbtnListWidgetState();
  LanguagesRadioBbtnListWidget() {
    languageId = CoreSession.selectedLanguageId;
  }
}

class _LanguagesRadioBbtnListWidgetState
    extends State<LanguagesRadioBbtnListWidget> {
  LoginService _loginService = new LoginService();

  @override
  Widget build(BuildContext context) {
    return Column(
      children: CoreSession.languages
          .map(
            (lang) => RadioListTile(
              groupValue: this.widget.languageId,
              onChanged: (value) {
                setState(() async {
                  if (value != null) {
                    this.widget.languageId = value as int;
                  } else {
                    this.widget.languageId = CoreSession.selectedLanguageId;
                  }
                  await _loginService.onChangeLanguageAfterLogin(
                      context, this.widget.languageId);

                  setState(() {
                    Navigator.pop(context);
                  });
                });
              },
              value: lang.languageId,
              title: Text(lang.description.toString()),
            ),
          )
          .toList(),
    );
  }
}
