import 'package:bottom_bar_matu/utils/app_utils.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:get/get.dart';

import '../enums/alert_types.dart';
import '../models/constant-operator.dart';
import '../theme/variables.dart';
import 'alert.widget.dart';

// ignore: must_be_immutable
class PointsDialogWidget extends StatefulWidget {
  String pointBalance = "";
  String usedPoint = "";
  double netTotal = 0;
  double pointValue = 0;
  double pointsConversionFactor = 1;
  Function updatePointValue;

  PointsDialogWidget(this.usedPoint, this.updatePointValue, this.netTotal);

  @override
  State<PointsDialogWidget> createState() => _PointsDialogWidgetState();
}

class _PointsDialogWidgetState extends State<PointsDialogWidget> {
  final TextEditingController _pointTextEditingController =
      TextEditingController();

  @override
  void initState() {
    super.initState();
    _pointTextEditingController.text =
        widget.usedPoint != "" && widget.usedPoint != "0"
            ? widget.usedPoint.toString()
            : "";
    widget.pointBalance =
        CoreSession.currentOperator['pointsBalance'].toString();
    this.widget.pointsConversionFactor =
        CoreSession.currentOperator[ConstantOperator.pointsConversionFactor] !=
                null
            ? double.parse(CoreSession
                .currentOperator[ConstantOperator.pointsConversionFactor]
                .toString())
            : 1;
    if (widget.usedPoint.isNotNullOrEmpty())
      this.widget.pointValue =
          double.parse(widget.usedPoint) * this.widget.pointsConversionFactor;
  }

  @override
  Widget build(BuildContext context) {
    return Directionality(
      textDirection: CoreSession.selectedLanguageId == 1
          ? TextDirection.ltr
          : TextDirection.rtl,
      child: AlertDialog(
        title: Text('Points'.tr,
            style: TextStyle(fontSize: 14.0, fontWeight: FontWeight.bold)),
        content: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            RichText(
              text: TextSpan(
                children: [
                  TextSpan(
                    text: "Your_balance_of_points_is".tr,
                    style: TextStyle(color: Colors.black),
                  ),
                  TextSpan(
                    text: " " + widget.pointBalance,
                    style: TextStyle(
                      fontWeight: FontWeight.bold,
                      color: Variables.color_primary,
                    ),
                  )
                ],
              ),
              textAlign: TextAlign.start,
            ),
            SizedBox(height: 10),
            TextField(
              controller: _pointTextEditingController,
              onChanged: (value) => {
                setState(() {
                  this.widget.pointValue = !value.isNullOrEmpty()
                      ? double.parse(value) * this.widget.pointsConversionFactor
                      : 0;
                })
              },
              decoration: InputDecoration(
                  hintText: 'Insert_Points'.tr,
                  suffixIcon: TextButton(
                    child:
                        //(widget.usedPoint.toString() != widget.pointBalance) ?
                        Text(
                      'All'.tr,
                      style: TextStyle(
                        fontWeight: FontWeight.bold,
                        fontSize: 10.0,
                      ),
                    ),
                    // : Icon(Icons.clear, size: 13),
                    onPressed: () {
                      setState(() {
                        //if (widget.usedPoint != widget.pointBalance) {
                        int allPoints = (this.widget.netTotal /
                                this.widget.pointsConversionFactor)
                            .floor();

                        widget.usedPoint =
                            double.parse(widget.pointBalance) > allPoints
                                ? allPoints.toString()
                                : widget.pointBalance;
                        this.widget.pointValue =
                            double.parse(widget.usedPoint) *
                                this.widget.pointsConversionFactor;
                        //} else {
                        //  widget.usedPoint = "";
                        //   this.widget.pointValue = 0;
                        // }
                        _pointTextEditingController.text = widget.usedPoint;
                      });
                    },
                  )),
              style: TextStyle(fontSize: 13.0),
              keyboardType: TextInputType.number,
            ),
            SizedBox(height: 10),
            Text(
              "point_value".tr + " : " + this.widget.pointValue.toString(),
              style: TextStyle(fontSize: 13),
            ),
            SizedBox(height: 10),
            Text(
              "net-total".tr +
                  " : " +
                  this
                      .widget
                      .netTotal
                      .toStringAsFixed(CoreSession.numberOfDigits)
                      .toString(),
              style: TextStyle(fontSize: 13),
            ),
          ],
        ),
        actions: <Widget>[
          TextButton(
            onPressed: () {
              Navigator.of(context).pop();
            },
            child: Text('close'.tr),
          ),
          TextButton(
            onPressed: () {
              if (_pointTextEditingController.text == "") {
                _pointTextEditingController.text = "0.0";
              }
              if (num.parse(_pointTextEditingController.text) >
                      num.parse(widget.pointBalance) ||
                  (this.widget.pointValue > this.widget.netTotal)) {
                CoreSession.showToast('Invalid_Points');
                return;
              }
              widget.usedPoint = _pointTextEditingController.text;
              this.widget.updatePointValue(widget.usedPoint);
              Navigator.of(context).pop();
            },
            child: Text('ok'.tr),
          ),
        ],
      ),
    );
  }
}
