// import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:photo_view/photo_view.dart';
import 'package:get/get.dart';

import '../theme/variables.dart';

class ViewImageWidget extends StatelessWidget {
  final String imageUrl;
  final String tag;
  ViewImageWidget(this.imageUrl, this.tag);
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
       backgroundColor: Variables.color_primary,
        title: Text("image".tr),
        automaticallyImplyLeading: false,
        actions: <Widget>[
          IconButton(
              icon: Icon(Icons.close),
              onPressed: () {
                Navigator.pop(context);
              }),
        ],
      ),
      body: GestureDetector(
        child: Center(
          child: Hero(
              tag: tag,
              child: PhotoView(
                backgroundDecoration: BoxDecoration(color: Colors.white),
                imageProvider: NetworkImage(imageUrl),
                minScale: PhotoViewComputedScale.contained * 0.8,
                maxScale: PhotoViewComputedScale.covered * 2,
              
              )
              // CachedNetworkImage(
              //   width: MediaQuery.of(context).size.width,
              //   fit: BoxFit.contain,
              //   imageUrl: imageUrl,
              // ),
              ),
        ),
        onTap: () {
          Navigator.pop(context);
        },
      ),
    );
  }
}
