﻿using DinkToPdf.Contracts;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Sonic.Web.DAL;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using System.IO;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;
using DinkToPdf;

namespace Sonic.Service.PL
{
    public class BackgroundService : IHostedService, IDisposable
    {
        private readonly ILogger<BackgroundService> _logger;
        private Timer _timerInsertImages;
        private ServicesService _servicesService;
        private bool _runInsertingImages = true;
        public BackgroundService(ILogger<BackgroundService> logger)
        {
            _logger = logger;
        }

        public void Dispose()
        {
            _timerInsertImages?.Dispose();
        }

        public Task StartAsync(CancellationToken cancellationToken)
        {
            _servicesService = new ServicesService(null);
            _logger.LogInformation("Timed Hosted Service running.");
            //ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Started ", null, "", 0);
            if (_runInsertingImages)
            {
                _timerInsertImages = new Timer(DoWorkImageInserting, null, TimeSpan.Zero,
                                        TimeSpan.FromMinutes(10));
            }
            return Task.CompletedTask;
        }

        private void DoWorkImageInserting(object state)
        {
            if (_runInsertingImages)
            {
                if (_servicesService.FillImagesForServices() != GlobalErrors.Success)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Running Images Background Service Failed", null, "", 0);
                }
                else
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Images Background Service Finished Successfully", null, "", 0);
                }
                _runInsertingImages = false;
                _timerInsertImages.Dispose();
            }
        }

        public Task StopAsync(CancellationToken cancellationToken)
        {
            _logger.LogInformation("Timed Hosted Service is stopping.");
            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Stopped ", null, "", 0);
            _timerInsertImages?.Change(Timeout.Infinite, 0);
            return Task.CompletedTask;
        }
    }
}
