﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Service;
using System;
using System.Reflection;

namespace Sonic.Services.Controllers.Customer
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class CustomerController : BaseController
    {
        private readonly CustomerService _customerService;
        private readonly IRequestRepository _requestRepository;
        public CustomerController(IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _customerService = new CustomerService(_requestRepository);
        }

        [HttpPost]
        [ActionName("AddNewCustomer")]
        public JsonResult InsertCustomerFromAPI([FromBody] CustomersModel CustomerDetails)
        {
            bool isEmailUsed = false; 
            try
            {
                if (CustomerDetails == null) 
                    return JSonResultResponse.GetErrorJSon("Error");

                GlobalErrors result = _customerService.InsertCustomerFromAPI(CustomerDetails, ref isEmailUsed);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(CustomerDetails.SiteCode, "Success");
                }
                else if (result == GlobalErrors.DataAlreadyExists)
                {
                    if (isEmailUsed)
                        return JSonResultResponse.GetErrorJSon("Email Already Added");
                    else
                    {
                        return JSonResultResponse.GetErrorJSon("Phone Number Already Added");
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateCustomer")]
        public JsonResult UpdateCustomerFromAPI([FromBody] CustomersModel CustomerDetails)
        {
            bool isEmailUsed = false;
            try
            {
                if (CustomerDetails == null || string.IsNullOrEmpty(CustomerDetails.SiteCode))
                    return JSonResultResponse.GetErrorJSon("Error");

                GlobalErrors result = _customerService.UpdateCustomerDetailsFromAPI(CustomerDetails, ref isEmailUsed);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(result, "Success");
                }
                else if (result == GlobalErrors.DataAlreadyExists)
                {
                    if (isEmailUsed)
                        return JSonResultResponse.GetErrorJSon("Email Already Added");
                    else
                    {
                        return JSonResultResponse.GetErrorJSon("Phone Number Already Added");
                    }
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon("No Data Found");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetCustomerDetails")]
        public JsonResult GetCustomerDetails(string SiteCode)
        {
            try
            {
                if (string.IsNullOrEmpty(SiteCode))
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
                CustomersModel CustomerDetails = new CustomersModel();
                GlobalErrors result = _customerService.GetCustomerDetailsFromAPI(SiteCode, ref CustomerDetails);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(CustomerDetails, "Success");
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon("No Data Found");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}
