﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Service.PL.Controllers.Echo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class EchoGeneralController : BaseController
    {
        private readonly EchoService _service;
        private readonly CustomerService _customerService;
        private readonly IRequestRepository _requestRepository;
        public EchoGeneralController(IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _service = new EchoService(_requestRepository);
            _customerService = new CustomerService(_requestRepository);
        }

        [HttpGet]
        [ActionName("GetCustomerAppProperties")]
        public JsonResult GetCustomerAppProperties()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                CustAppPropertiesModel custAppProperties = new CustAppPropertiesModel();
                result = _service.GetCustomerProperties(ref custAppProperties);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(custAppProperties, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetCustomerAppDashboards")]
        public JsonResult GetCustomerAppDashboards()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<CustomerDashboardModel> list = new List<CustomerDashboardModel>();
                result = _service.GetCustomerAppDashboards(ref list);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(list, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetCustomerAppProfileData")]
        public JsonResult GetCustomerAppProfileData()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<OperatorCustomerModel> operatorCustomers = new List<OperatorCustomerModel>();
                result = _service.GetCustomerAppProfileData(ref operatorCustomers);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(operatorCustomers, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetCustomerAppFAQs")]
        public JsonResult GetCustomerAppFAQs()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<CustomerAppFAQs> customerAppFAQs = new List<CustomerAppFAQs>();
                result = _service.GetCustomerAppFAQs(ref customerAppFAQs);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(customerAppFAQs, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("SaveContactUsMessage")]
        public JsonResult SaveContactUsMessage([FromBody] ContactUsModel message)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                var result = _service.SaveContactUsMessage(message);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }        
        [HttpPost]
        [ActionName("ChangePassword")]
        public JsonResult ChangePassword([FromBody] OperatorModel operatorModel)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                var result = _service.ChangePassword(operatorModel);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UpdateCustomerProfileData")]
        public JsonResult UpdateCustomerProfileData([FromBody] OperatorCustomerModel customerOperators)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                var result = _service.UpdateCustomerProfileData(customerOperators);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetCompanyDetails")]
        public JsonResult GetCompanyDetails()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                CompanyDetails company = new CompanyDetails();
                result = _service.GetCompanyDetails(_requestRepository.CurrentEchoOperator.RouteOrganizationId, ref company);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(company, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SetAccountInactive")]
        public JsonResult SetAccountInactive([FromBody] OperatorModel operatorModel)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                var result = _customerService.UpdateInactiveCustomer(operatorModel.CustomerId, false);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}