﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Service.PL.Controllers.Echo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class EchoItemController : BaseController
    {
        private readonly ItemService _itemService;
        private readonly IRequestRepository _requestRepository;
        public EchoItemController(IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _itemService = new ItemService(_requestRepository);
        }

        [HttpGet]
        [ActionName("GetItemCategories")]
        public JsonResult GetItemCategories(int divisionId)
        {
            try
            {
                List<CategoryModel> list = new List<CategoryModel>();
                var result = _itemService.GetEchoCategories(divisionId, ref list);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(list, string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetDivisions")]
        public JsonResult GetDivisions()
        {
            try
            {
                List<DivisionModel> list = new List<DivisionModel>();
                var result = _itemService.GetEchoDivisions(ref list);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(list, string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetBrands")]
        public JsonResult GetBrands()
        {
            try
            {
                List<GeneralModel> list = new List<GeneralModel>();
                var result = _itemService.GetEchoBrands(ref list);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(list, string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetItems")]
        public JsonResult GetItems([FromBody] EchoGeneralFilter filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                List<ItemPackModel> list = new List<ItemPackModel>();
                List<int> categoriesIds = new List<int>();
                var result = _itemService.GetEchoItems(filter, ref list, ref categoriesIds, true);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        items = list,
                        categories = categoriesIds
                    };
                    return JSonResultResponse.GetSuccessJSon(data, string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetItemsFromIonic")]
        public JsonResult GetItemsFromIonic([FromBody] EchoGeneralFilter filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                List<ItemPackModel> list = new List<ItemPackModel>();
                List<ItemPackModel> powerSKUList = new List<ItemPackModel>();
                List<ItemPackModel> newItemlist = new List<ItemPackModel>();
                List<ItemPackModel> initiativelist = new List<ItemPackModel>();
                List<ItemPackModel> bestSellersList = new List<ItemPackModel>();
                int itemCountPerLine = 6;
                List<int> categoriesIds = new List<int>();
                var result = _itemService.GetEchoItems(filter, ref list, ref categoriesIds, false);           
                if (result == GlobalErrors.Success)
                {
                    if (list != null && list.Count > 0)
                    {
                        powerSKUList = list.FindAll(i => i.IsPowerSKU).ToList();
                        newItemlist = list.FindAll(i => i.IsNew).ToList();
                        initiativelist = list.FindAll(i => i.IsInitiative).ToList();
                        bestSellersList = list.FindAll(i => i.IsBestSeller).OrderBy(i => i.BestSellerSeq).ToList();
                    }
                    var data = new
                    {
                        items = list,
                        powerSKUList = powerSKUList,
                        newItemlist = newItemlist,
                        initiativelist = initiativelist,
                        bestSellersList = bestSellersList,
                        categories = categoriesIds
                    };
                    return JSonResultResponse.GetSuccessJSon(data, string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetEchoHomePageData")]
        public JsonResult GetEchoHomePageData([FromBody] EchoGeneralFilter filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                List<ItemPackModel> Itemslist = new List<ItemPackModel>();
                List<EchoCustomeHomePageModel> homePagesections = new List<EchoCustomeHomePageModel>();
                int NotificationCount = 0;
                var result = _itemService.GetEchoHomePageData(ref homePagesections, ref Itemslist, ref NotificationCount, filter);

                if (result == GlobalErrors.Success)
                {
                    
                       var data = new
                    {
                        homePagesections = homePagesections,
                        items = Itemslist,
                        notificationCount = NotificationCount
                    };
                    return JSonResultResponse.GetSuccessJSon(data, string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetItemDocuments")]
        public JsonResult GetItemDocuments(int itemId)
        {
            try
            {
                List<string> itemDocuments = new List<string>();
                var result = _itemService.GetItemDocuments(itemId, ref itemDocuments);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(itemDocuments, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("SaveCustomerBasket")]
        public JsonResult SaveCustomerBasket([FromBody] BasketModel basket)
        {
            try
            {

                GlobalErrors result = _itemService.SaveCustomerBasket(basket);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon("", "Success");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SavePackRate")]
        public JsonResult SetPackRate([FromBody] RateModel Rate)
        {
            try
            {

                GlobalErrors result = _itemService.savePackRate(Rate);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon("", "Success");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

    }
}