﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Service.PL.Controllers.Echo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class EchoNonOperatorController : BaseController
    {
        private readonly EchoService _service;
        private readonly CustomerService _customerService;
        private readonly LocationService _locationService;
        private readonly IRequestRepository _requestRepository;
        public EchoNonOperatorController(IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _service = new EchoService(_requestRepository);
        }

        [HttpGet]
        [ActionName("GetCustomerAppSignUpFields")]
        public JsonResult GetCustomerAppSignUpFields()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<CustomerAppSignUpFields> signUpFields = new List<CustomerAppSignUpFields>();
                result = _service.GetCustomerAppSignUpFields(ref signUpFields);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(signUpFields, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, 1));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, 1));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetLocationHierarchy")]
        public JsonResult GetLocationHierarchy()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                int locationHierarchyLevel = -1;
                List<Country> countries = new List<Country>();
                List<State> states = new List<State>();
                List<City> cities = new List<City>();
                List<Area> areas = new List<Area>();
                List<Street> streets = new List<Street>();

                //result = _service.GetLocationHierarchy(ref locationHierarchyLevel, ref countries, ref states, ref cities, ref areas, ref streets);
                if (result == GlobalErrors.Success)
                {
                    var data  = new 
                    {
                        locationHierarchyLevel = locationHierarchyLevel,
                        countries = countries,
                        states = states,
                        cities = cities,
                        areas = areas,
                        streets = streets,
                        Desc_Geographical_Location_Name_One = ResourcesManager.TranslateKey(MessagesConstants.Desc_Geographical_Location_Name_One, _requestRepository.LanguageId),
                        Desc_Geographical_Location_Name_Two = ResourcesManager.TranslateKey(MessagesConstants.Desc_Geographical_Location_Name_Two, _requestRepository.LanguageId),
                        Desc_Geographical_Location_Name_Three = ResourcesManager.TranslateKey(MessagesConstants.Desc_Geographical_Location_Name_Three, _requestRepository.LanguageId),
                        Desc_Geographical_Location_Name_Four = ResourcesManager.TranslateKey(MessagesConstants.Desc_Geographical_Location_Name_Four, _requestRepository.LanguageId),
                        Desc_Geographical_Location_Name_Five = ResourcesManager.TranslateKey(MessagesConstants.Desc_Geographical_Location_Name_Five, _requestRepository.LanguageId)
                    };
                    return JSonResultResponse.GetSuccessJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetEchoGuestOpratorDataAndSettings")]
        public JsonResult GetEchoGuestOpratorDataAndSettings()
        {
            try
            {
                var data = new
                {
                    CustomerAppGestUserOperators = EchoService.CustomerAppGestUserOperators,
                    CustomerAppSettings = EchoService.CustomerAppSettings,
                    CustomerAppGuestUserCaption = EchoService.CustomerAppGuestUserCaption,

                };
                return JSonResultResponse.GetSuccessJSon(data, MessagesConstants.Desc_Success_Getting_Data);
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [ActionName("GetAllLanguages")]
        public JsonResult GetAllLanguages()
        {
            var langauges = new List<LanguageModel>();
            try
            {
                var result = SettingService.GetAllLanguages(ref langauges, true);

                if (result == GlobalErrors.Success && langauges.Count > 0)
                {
                    return JSonResultResponse.GetSuccessJSon(langauges, "getting language successfully");
                }
                else
                {
                    langauges = new List<LanguageModel>();
                    var language = new LanguageModel()
                    {
                        LanguageId = 1,
                        Description = "English",
                        Code = "EN",
                        RTL = false,
                        Active = true
                    };
                    langauges.Add(language);
                    return JSonResultResponse.GetSuccessJSon(langauges, "getting language successfully");
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon("Error while get languages");
            }
        }
    }
}