﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Service.PL.Controllers.Echo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class EchoNotificationsController : BaseController
    {
        private readonly NotificationService _service;
        private readonly IRequestRepository _requestRepository;
        public EchoNotificationsController(IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _service = new NotificationService(null, _requestRepository);

        }
        [HttpGet]
        [ActionName("GetNotificationList")]
        public JsonResult GetNotificationList(int pageNumber, int pageSize)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<NotificaitonsModel> notificationList = new List<NotificaitonsModel>();
                result = _service.GetEchoNotificationList(pageNumber, pageSize, ref notificationList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(notificationList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetBadgeCount")]
        public JsonResult GetBadgeCount()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                int badge = 0;
                result = _service.GetBadgeCount(ref badge);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(badge, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UpdateDeviceToken")]
        public JsonResult UpdateDeviceToken([FromBody] EchoCustomerModel cusromer)
        {

            GlobalErrors result = GlobalErrors.Success;
            try
            {
                result = _service.UpdateCustomerDeviceToken(cusromer.DeviceToken);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon("");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }        
    }
}